<?php
/**
 * NewsFeeds SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

define( '_COM_SEF_PRIORITY_NEWSFEEDS_FEED_ITEMID',      15 );
define( '_COM_SEF_PRIORITY_NEWSFEEDS_FEED',             20 );
define( '_COM_SEF_PRIORITY_NEWSFEEDS_CATEGORY_ITEMID',  25 );
define( '_COM_SEF_PRIORITY_NEWSFEEDS_CATEGORY',         30 );

class SefExt_com_newsfeeds extends SefExt
{
    function fixFeedId(&$uri, $varName)
    {
        $value = $uri->getVar($varName);
        if (! is_null($value)) {
            $pos = strpos($value, '-');
            if ($pos !== false) {
                $value = substr($value, 0, $pos);
                $uri->setVar($varName, $value);
            }
        }
    }
    
    function beforeCreate(&$uri) {
        // Remove the part after ':' from variables
        if (!is_null($uri->getVar('id'))) {
            SEFTools::fixVariable($uri, 'id');
            $this->fixFeedId($uri, 'id');
        }
        if (!is_null($uri->getVar('catid'))) {
            SEFTools::fixVariable($uri, 'catid');
        }
        
        if($uri->getVar('view') == 'categories' && ! (int) $uri->getVar('id')) {
			$uri->delVar('id');        	
        }
        
        if (is_null($uri->getVar('view'))) {
            $uri->setVar('view', 'categories');
        }
        
        

        return;
    }
    
	function getCategoryTitle($id, $getLastOne = false, $title = array())
    {
        if ($this->params->get('show_category') == 0 && ! $getLastOne)
            return $title;
        
        $database = &JFactory::getDBO();
        $database->setQuery('SELECT `id`, ' . (SEFTools::UseAlias($this->params, 'category_alias') ? '`alias` AS `title`' : '`title`') . ', `description`, `parent_id` FROM `#__categories` WHERE `id` = ' . (int) $id . ' AND `extension` = "com_newsfeeds"');
        
        if (($category = &$database->loadObject())) {
            $this->metadesc = ($category->description = JString::trim($category->description)) ? $category->description : $this->metadesc;
            
            array_unshift($title, ($this->params->get('categoryid') == 1 ? $id . '-' . $category->title : $category->title));
            
            if ($this->params->get('show_category') == 2 && (int) $category->parent_id)
                $title = $this->getCategoryTitle($category->parent_id, $getLastOne, $title);
        }
        
        return $title;
    }
    
    function create(&$uri) {
        $sefConfig =& SEFConfig::getConfig();
        $database =& JFactory::getDBO();
        
        $this->params =& SEFTools::getExtParams('com_newsfeeds');
        
        $vars = $uri->getQuery(true);
        extract($vars);
        
        // JF translate extension.
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

        $title = array();
        
        $title[] = JoomSEF::_getMenuTitle($option, @$this_task);
        
        if (@$view == 'category' && isset($id)) {
            $title = array_merge($title, $this->getCategoryTitle($id, true));
        }

        if (@$view == "newsfeed") {
            if( !empty($catid) ) {
                $title = array_merge($title, $this->getCategoryTitle($catid, true));
            }
            
            if (empty($feedid)) {
                $feedid = $id;
            }
            
            $field = 'name';
            if( SEFTools::UseAlias($this->params, 'feed_alias') ) {
                $field = 'alias';
            }
            
            $database->setQuery("SELECT `$field` AS `name` $jfTranslate FROM `#__newsfeeds` WHERE `id` = '$feedid'");
            $rows = $database->loadObjectList();

            if ($database->getErrorNum()) {
                return $uri;
            }
            elseif (@count($rows) > 0 && !empty($rows[0]->name)) {
                $name = $rows[0]->name;
                if( $this->params->get('feedid', '0') ) {
                    $name = $feedid . '-' . $name;
                }
                $title[] = $name;
            }
        }

        if (isset($format)) {
            if ($format == 'feed' && isset($type)) {
                $title[] = $type;
            }
            else {
                $title[] = $format;
            }
        }

        $newUri = $uri;
        if (count($title) > 0) {
            // Generate meta tags
            $metatags = $this->getMetaTags();
        
            $priority = $this->getPriority($uri);
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$vars['lang'], null, null, $metatags, $priority);
        }
        
        return $newUri;
    }
    
    function getPriority(&$uri)
    {
        $itemid = $uri->getVar('Itemid');
        $view = $uri->getVar('view');
        
        switch($view)
        {
            case 'newsfeed':
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_NEWSFEEDS_FEED;
                } else {
                    return _COM_SEF_PRIORITY_NEWSFEEDS_FEED_ITEMID;
                }
                break;
                
            case 'category':
                if (is_null($itemid)) {
                    return _COM_SEF_PRIORITY_NEWSFEEDS_CATEGORY;
                } else {
                    return _COM_SEF_PRIORITY_NEWSFEEDS_CATEGORY_ITEMID;
                }
                break;
                
            default:
                return null;
        }
    }
}
?>
