<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SEFViewSEFUrls extends SEFView
{
	function display($tpl = null)
	{
	    $mainframe =& JFactory::getApplication();
	    $viewmode = $mainframe->getUserStateFromRequest('sef.sefurls.viewmode', 'viewmode', 0);
	    if ($viewmode == 2) {
	        $icon = 'url-user.png';
	    }
	    else if( $viewmode == 1 ) {
	        $icon = '404-logs.png';
	    }
	    else {
	        $icon = 'url-edit.png';
	    }
		JToolBarHelper::title(JText::_('COM_SEF_JOOMSEF_URL_MANAGER'), $icon);
		
        $this->assign($this->getModel());
        $lists =& $this->get('Lists');
        
		$bar =& JToolBar::getInstance();
		
		// Actions
		$bar->appendButton('Custom', $lists['selection']);
		$bar->appendButton('Custom', $lists['actions']);
		$bar->appendButton('Custom', '<input type="button" value="'.JText::_('COM_SEF_PROCEED').'" onclick="doAction();" />');
		JToolBarHelper::divider();
		
		JToolBarHelper::addNew();
		if ($this->viewmode == 1) {
		    // 404 log
		    JToolBarHelper::addNew('create301', 'COM_SEF_CREATE_301');
		}
		JToolBarHelper::editList();
		JToolBarHelper::spacer();
		JToolBarHelper::custom('showimport', 'import', '', 'COM_SEF_IMPORT', false);
		JToolBarHelper::spacer();
		JToolBarHelper::back('COM_SEF_BACK', 'index.php?option=com_sef');
		
		// Get data from the model
        $this->assignRef('items', $this->get('Data'));
        $this->assignRef('total', $this->get('Total'));
        $this->assignRef('lists', $lists);
        $this->assignRef('pagination', $this->get('Pagination'));
        
        JHTML::_('behavior.tooltip');
        
		parent::display($tpl);
	}

    function showUpdate()
    {
        JToolBarHelper::title( JText::_('COM_SEF_JOOMSEF_URLS_UPDATE'), 'url-update.png' );
        
        $this->setLayout('update');
        $this->assign('totalUrls', $this->get('UrlsToUpdate'));
        
        parent::display();
    }

    function showUpdateMeta()
    {
        JToolBarHelper::title( JText::_('COM_SEF_JOOMSEF_META_TAGS_UPDATE'), 'url-update.png' );
        
        $this->setLayout('updatemeta');
        $this->assign('totalUrls', $this->get('UrlsToUpdate'));
        
        parent::display();
    }
}
