<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.10
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2021 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class SefDomainFactory
{
    /** @var string */
    protected $rootDomain;

    /** @var string[] */
    protected $langDomains;

    /**
     * @return string
     */
    public function getRootDomain()
    {
        if (is_null($this->rootDomain)) {
            $this->rootDomain = $this->prepareDomain(JUri::root(), true);
        }
        return $this->rootDomain;
    }

    /**
     * @param string $lang
     * @return string
     */
    public function getLangDomain($lang)
    {
        if (is_null($this->langDomains)) {
            $this->langDomains = array();

            $sefConfig = SEFConfig::getConfig();
            if ($sefConfig->langEnable && $sefConfig->langPlacementJoomla == _COM_SEF_LANG_DOMAIN) {
                foreach ($sefConfig->subDomainsJoomla as $lng => $host) {
                    $this->langDomains[$lng] = $this->prepareDomain($host, false);
                }
            }
        }

        return isset($this->langDomains[$lang]) ? $this->langDomains[$lang] : $this->getRootDomain();
    }

    /**
     * @param string $domain
     * @param bool $wwwHandle
     * @return string
     */
    protected function prepareDomain($domain, $wwwHandle)
    {
        $sefConfig = SEFConfig::getConfig();

        // Remove scheme
        $pos = strpos($domain, '://');
        if ($pos !== false) {
            $domain = substr($domain, $pos + 3);
        }

        // Remove everything after host (also port if present)
        $pos = strpos($domain, '/');
        $pos2 = strpos($domain, ':');
        if ($pos === false || ($pos2 !== false && $pos2 < $pos)) {
            $pos = $pos2;
        }
        if ($pos !== false) {
            $domain = substr($domain, 0, $pos);
        }

        // Handle scheme
        if ($sefConfig->sitemap_ssl) {
            $domain = 'https://'.$domain;
        }
        else {
            $domain = 'http://'.$domain;
        }

        // Adjust domain according to www handling
        if ($wwwHandle) {
            if ($sefConfig->wwwHandling != _COM_SEF_WWW_NONE) {
                if ($sefConfig->wwwHandling == _COM_SEF_WWW_USE_WWW) {
                    if (strpos($domain, '://www.') === false) {
                        $domain = str_replace('://', '://www.', $domain);
                    }
                }
                else if ($sefConfig->wwwHandling == _COM_SEF_WWW_USE_NONWWW) {
                    $domain = str_replace('://www.', '://', $domain);
                }
            }
        }

        // Add base
        $domain .= JURI::root(true);

        // Add slash
        if(substr($domain, -1) != '/') {
            $domain .= '/';
        }

        return $domain;
    }
}
