<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.10
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2021 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class SefMultilanguageUrlDomainProvider implements ISefUrlDomainProvider
{
    /** @var SefDomainFactory */
    protected $df;

    /**
     * @param SefDomainFactory $domainFactory
     */
    public function __construct($domainFactory)
    {
        $this->df = $domainFactory;
    }

    /**
     * @param SefSitemapUrl $url
     * @return string
     */
    public function getUrlDomain($url)
    {
        $lang = $url->getLang();
        return $lang ? $this->df->getLangDomain($lang) : $this->df->getRootDomain();
    }
}
