<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   4.7.10
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2021 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class SefMultiSitemapXmlGenerator implements ISefSitemapXmlGenerator
{
    /** @var SefSitemapXmlGenerator[] */
    protected $generators;

    /**
     * @param string[] $filenames
     * @param SefDomainFactory $domainFactory
     */
    public function __construct($filenames, $domainFactory)
    {
        // Create generators for individual sitemaps
        $this->generators = array();

        $languages = JLanguageHelper::getLanguages();
        foreach ($languages as $language) {
            $code = $language->sef;
            $filename = isset($filenames[$code]) ? $filenames[$code] : 'sitemap_'.$code;
            $domain = $domainFactory->getLangDomain($code);
            $this->generators[$code] = new SefSitemapXmlGenerator(
                $filename,
                new SefSingleUrlDomainProvider($domain),
                $domain
            );
        }
    }

    public function open()
    {
        foreach ($this->generators as $generator) {
            $generator->open();
        }
    }

    /**
     * @param SefSitemapUrl $url
     */
    public function addUrl($url)
    {
        // Select correct XML generator
        $lang = $url->getLang();
        if (isset($this->generators[$lang])) {
            $this->generators[$lang]->addUrl($url);
        }
    }

    public function close()
    {
        // Close all generators
        foreach ($this->generators as $generator) {
            $generator->close();
        }
    }

    /**
     * @return string[]
     */
    public function getSitemapsUrls()
    {
        $urls = array();
        foreach ($this->generators as $generator) {
            $urls = array_merge($urls, $generator->getSitemapsUrls());
        }
        return $urls;
    }
}
