<?php
/**
 * ReMOSitory SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

class sefext_com_rsgallery2 extends sef_joomsef
{
    var $params;
    
    // Creates an array of nested categories from given category id
    function GetCategories($catId)
    {
        global $database;

        $categories = array();
        
        // If set not to add any category
        if( $this->params->get('categories', '2') == '0' )  $catId = 0;
        
        while ($catId > 0) {
            $database->setQuery("SELECT `id`, `name`, `parent` FROM `#__rsgallery2_galleries` WHERE `id` = ".$catId);
            $row = null;
            $database->loadObject($row);
            
            $name = ($this->params->get('categoryid', '0') != '0' ? $catId.'-' : '').$row->name;
            array_unshift ($categories, $name);

            // If set to add last category only
            if( $this->params->get('categories', '2') == '1' )   break;
            
            $catId = $row->parent;
        }
        
        return $categories;
    }
    
    // Returns file title for given ID
    function GetFileTitle($id) {
        global $database;
        
        $database->setQuery("SELECT `id`, `title` FROM `#__rsgallery2_files` WHERE `id` = $id");
        $row = null;
        $database->loadObject($row);
        
        $name = ($this->params->get('fileid', '0') != '0' ? $id.'-' : '').$row->title;
        
        return $name;
    }

    function create($string, &$vars) {
        // Load the texts to use in URL
        $texts = SEFTools::getExtTexts('com_rsgallery2');
        $this->params = SEFTools::getExtParams('com_rsgallery2');

        // Create an associative array for page => url_text conversion
        $pages['my_galleries']  = $texts['_MY_GALLERIES'];
        $pages['slideshow']     = $texts['_SLIDESHOW'];
        $pages['downloadfile']  = $texts['_DOWNLOADFILE'];
        $pages['vote']          = $texts['_VOTE'];
        $pages['addcomment']    = $texts['_ADDCOMMENT'];
        $pages['editusercat']   = $texts['_EDITUSERCAT'];
        $pages['makeusercat']   = $texts['_MAKEUSERCAT'];
        $pages['delusercat']    = $texts['_DELUSERCAT'];
        $pages['edit_image']    = $texts['_EDIT_IMAGE'];
        $pages['delete_image']  = $texts['_DELETE_IMAGE'];
        $pages['save_image']    = $texts['_SAVE_IMAGE'];

        // Extract variables
        extract($vars);
        $title = array();
        
        $title[] = getMenuTitle(@$option, @$task, @$Itemid);
        
        // Get category tree
        if( isset($catid) && ($catid != 0) ) {
            $title = array_merge($title, $this->GetCategories($catid));
        }
        
        // Get picture name
        if( isset($id) && ($id != 0) ) {
            $title[] = $this->GetFileTitle($id);
        }
        
        if( @$page == 'inline' ) {
            unset($page);
        }
        
        if( isset($page) && in_array($page, array_keys($pages)) ) {
            $title[] = $pages[$page];

            unset($page);
        }
        
        if (count($title) > 0) {
            $nonSefVars = array();
            if( isset($limitstart) )    $nonSefVars['limitstart'] = $limitstart;
            if( isset($limit) )         $nonSefVars['limit'] = $limit;
            
            $string = sef_joomsef::sefGetLocation($string, $title, @$page, @$limit, @$limitstart, @$lang, $nonSefVars);
        }
        
        return $string;
    }
}