<?php
/**
 * AlphaContent SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

class SefExt_com_alphacontent extends SefExt
{
    function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);
        
        return array($this->nonSefVars, $this->ignoreVars);
    }
    
    function _createNonSefVars(&$uri)
    {
        if (isset($this->nonSefVars) && isset($this->ignoreVars))
            return;
            
        $this->nonSefVars = array();
        $this->ignoreVars = array();
        
        if (!is_null($uri->getVar('sort')))
            $this->ignoreVars['sort'] = $uri->getVar('sort');
        if (!is_null($uri->getVar('ordering')))
            $this->ignoreVars['ordering'] = $uri->getVar('ordering');
            
        if (!is_null($uri->getVar('limit')))
            $this->nonSefVars['limit'] = $uri->getVar('limit');
        if (!is_null($uri->getVar('limitstart')))
            $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
    }
    
    function beforeCreate(&$uri)
    {
        if (!is_null($uri->getVar('id')))    SEFTools::fixVariable($uri, 'id');
    }
    
    function create(&$uri) {
        $sefConfig =& SEFConfig::getConfig();
        $database =& JFactory::getDBO();

        // Use this to get variables from the original Joomla! URL, such as $task, $page, $id, $catID, ...
        $vars = $uri->getQuery(true);
        extract($vars);
        $title = array();

        $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

        if (isset($section)/* && $sefConfig->showSection*/) {
            $sql = "SELECT title, id FROM #__sections WHERE id=".$section;
            $database->setQuery($sql);
            if (($section_name = $database->loadResult())) {
                $title[] = $section_name; //section name
            } else {
                if( $section == '0' ) {
                    $title[] = JText::_('No section');
                } else {
                    if( strpos($section, 'com_') === 0 ) {
                        $title[] = substr($section, 4);
                    } else {
                        $title[] = $section;
                    }
                }
            }
            //unset($vars['section']);
        }

        if (isset($cat) || isset($category)) {
            if (!isset($cat)) {
                $cat = $category;
            }
            $sql = "SELECT title, id FROM #__categories WHERE id=".$cat;
            $database->setQuery($sql);
            if ($cat_name = $database->loadResult()) {
                $title[] = $cat_name; //category name
            }
            //unset($vars['cat']);
        }

        if (isset($id)) {
            $sql = "SELECT title, id FROM #__content WHERE id = $id";
            $database->setQuery($sql);
            if ($cTitle = $database->loadResult()) {
                $title[] = $cTitle; //item title
            }
            //unset($vars['id']);
            if (@$task == 'view') unset($task);
        }

        // Add letter name.
        if (isset($alpha) || isset($letter)) {
            if (!isset($alpha)) {
                $alpha = $letter;
            }
            if ($alpha == '#') {
                $alpha = JText::_('Hash');
            }
            $title[] = $alpha;
        }

        $newUri = $uri;
        if (count($title) > 0) {
            $this->_createNonSefVars($uri);
            
            $newUri = JoomSEF::_sefGetLocation($uri, $title, @$task, @$limit, @$limitstart, @$lang, $this->nonSefVars, $this->ignoreVars);
        }
        
        return $newUri;
    }
}
?>
