<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

class VmsmsModelConfig extends VmsmsModel
{
    public function getLists()
    {
        $config = VmsmsConfig::getInstance();
        
        $lists = array();
        
        $lists['username'] = '<input type="text" name="username" id="username" value="'.$config->username.'" size="60" />';
        $lists['apiKey'] = '<input type="text" name="apiKey" id="apiKey" value="'.$config->apiKey.'" size="60" />';
        
        // Get languages
        $languages = JLanguage::getKnownLanguages();
        
        // Get VM statuses
        $states = $this->getVmStates();
        
        // Prepare lists for messages configuration
        $lists['sendUser'] = array();
        $lists['sendCustomer'] = array();
        $lists['userText'] = array();
        $lists['customerText'] = array();
        
        foreach ($states as $state) {
            $stat = $state->id;
            $suffix = '['.$stat.']';
            
            $lists['sendUser'][$stat] = $this->booleanRadio('sendUser'.$suffix, '', $config->getSendUser($stat));
            $lists['sendCustomer'][$stat] = $this->booleanRadio('sendCustomer'.$suffix, '', $config->getSendCustomer($stat));
            $lists['userText'][$stat] = '<textarea name="userText'.$suffix.'" id="userText_'.$stat.'" cols="50" rows="4">'.$config->getUserText($stat).'</textarea>';
            
            foreach ($languages as $language) {
                $lang = $language['tag'];
                $suffix = '['.$stat.']['.$lang.']';
                $id = 'customerText_'.$stat.'_'.$lang;
                
                $lists['customerText'][$stat][$lang] = '<textarea name="customerText'.$suffix.'" id="'.$id.'" cols="50" rows="4">'.$config->getCustomerText($stat, $lang).'</textarea>';
            }
        }
        
        // Prepare lists for phone fields selection
        $lists['primary_phone'] = $this->createVmFieldsList('primary_phone', $config->primary_phone);
        $lists['secondary_phone'] = $this->createVmFieldsList('secondary_phone', $config->secondary_phone);
        
        // JS data for filters
        $lists['includeNumbers'] = $this->filtersToJs($config->includeNumbers);
        $lists['excludeNumbers'] = $this->filtersToJs($config->excludeNumbers);
        
        $lists['allowUnicode'] = $this->booleanRadio('allowUnicode', '', $config->allowUnicode);
        
        return $lists;
    }
    
    private function createVmFieldsList($name, $selected)
    {
        $vals = array();
        $vals[] = JHtml::_('select.option', '', JText::_('COM_VMSMS_SELECT_FIELD'));
        
        $fields = $this->getVmFields();
        if (is_array($fields)) {
            foreach ($fields as $field) {
                $vals[] = JHtml::_('select.option', $field, $field);
            }
        }
        
        return JHtml::_('select.genericlist', $vals, $name, null, 'value', 'text', $selected);
    }
    
    private function getVmFields()
    {
        static $fields;
        
        if (!isset($fields)) {
            if (VmsmsHelper::isVm1()) {
                $this->_db->setQuery("SELECT `name` FROM `#__vm_userfield` WHERE `published` = 1 ORDER BY `name`");
                $fields = $this->_db->loadResultArray();
            }
            else if (VmsmsHelper::isVm2()) {
                $this->_db->setQuery("SELECT `name` FROM `#__virtuemart_userfields` WHERE `published` = 1 ORDER BY `name`");
                $fields = $this->_db->loadResultArray();
            }
            
            if (!is_array($fields)) {
                $fields = array();
            }
        }
        
        return $fields;
    }
    
    public function getVmStates()
    {
        static $states;
        
        if (!isset($states)) {
            if (VmsmsHelper::isVm1()) {
                $this->_db->setQuery("SELECT `order_status_id` AS `id`, `order_status_name` AS `name` FROM `#__vm_order_status` ORDER BY `list_order`");
                $states = $this->_db->loadObjectList();
            }
            else if (VmsmsHelper::isVm2()) {
                $this->_db->setQuery("SELECT `virtuemart_orderstate_id` AS `id`, `order_status_name` AS `name` FROM `#__virtuemart_orderstates` WHERE `published` = 1 ORDER BY `ordering`");
                $states = $this->_db->loadObjectList();
            }
            
            if (!is_array($states)) {
                $states = array();
            }
        }
        
        return $states;
    }
    
    public function store()
    {
        $config = VmsmsConfig::getInstance();
        
        $config->username = JRequest::getVar('username', '');
        $config->apiKey = JRequest::getVar('apiKey', '');
        
        $config->sendUser = JRequest::getVar('sendUser', array(), 'default', 'array');
        $config->sendCustomer = JRequest::getVar('sendCustomer', array(), 'default', 'array');
        $config->userText = JRequest::getVar('userText', array(), 'default', 'array');
        $config->customerText = JRequest::getVar('customerText', array(), 'default', 'array');
        
        $config->primary_phone = JRequest::getVar('primary_phone', '');
        $config->secondary_phone = JRequest::getVar('secondary_phone', '');
        
        // Phone numbers settings
        $localCountry = JRequest::getVar('local-country', '');
        $localCountry = explode(',', $localCountry);
        $localCountry = array('country_code' => $localCountry[0], 'dial_code' => $localCountry[1]);
        
        $config->localCountry = $localCountry;
        $config->localCountryMinDigits = JRequest::getVar('prefix-number', '');
        $config->includeNumbers = $this->filtersFromJs(JRequest::getVar('include-filters', ''));
        $config->excludeNumbers = $this->filtersFromJs(JRequest::getVar('exclude-filters', ''));
        
        $config->allowUnicode = intval(JRequest::getVar('allowUnicode'));
        
        return $config->save();
    }
    
    protected function filtersToJs($filters)
    {
        $js = array();
        foreach ($filters as $dial => $data) {
            $code = $data['country_code'];
            $patterns = $data['filters'];
            
            foreach ($patterns as $pattern) {
                $js[] = $code.','.$dial.','.$pattern;
            }
        }
        
        return implode(';', $js);
    }
    
    protected function filtersFromJs($js)
    {
        $js = trim($js);
        $filters = array();
        
        if (empty($js)) {
            return $filters;
        }
        
        $patterns = explode(';', $js);
        foreach ($patterns as $pattern) {
            $parts = explode(',', $pattern);
            $code = $parts[0];
            $dial = $parts[1];
            $filter = $parts[2];
            
            if (!isset($filters[$dial])) {
                $filters[$dial] = array();
                $filters[$dial]['country_code'] = $code;
                $filters[$dial]['filters'] = array();
            }
            
            $filters[$dial]['filters'][] = $filter;
        }
        
        return $filters;
    }
}
