<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

class VmsmsModelLogs extends VmsmsModel
{
    public function getLogs()
    {
        $config = VmsmsConfig::getInstance();
        
        $logs = false;
        if (!empty($config->username) && !empty($config->apiKey)) {
            $api = AVmsmsSmsService::getInstance();
            $logs = $api->getLogs($config->username, $config->apiKey);
            
            $actions = array(
                'S' => JText::_('COM_VMSMS_LOG_ACTION_SEND'),
                'C' => JText::_('COM_VMSMS_LOG_ACTION_CHARGE'),
                'E' => JText::_('COM_VMSMS_LOG_ACTION_ERROR')
            );
            
            if (is_array($logs)) {
                foreach ($logs as &$log) {
                    $log->actionText = (isset($actions[$log->action]) ? $actions[$log->action] : $log->action);
                }
            }
        }
        
        return $logs;
    }
}
