/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

var VmuserfieldSmscheck = VmuserfieldSmscheck || {};

VmuserfieldSmscheck.showError = function(id, text) {
    var block = document.getElementById(id+'_error_block');
    if (!block)
        return;
    
    block.innerHTML = text;
    block.style.display = '';
};

VmuserfieldSmscheck.showSuccess = function(id, text) {
    var block = document.getElementById(id+'_success_block');
    if (!block)
        return;
    
    block.innerHTML = text;
    block.style.display = '';
};

VmuserfieldSmscheck.sendCode = function(id, phoneFieldId) {
    var field = document.getElementById(id);
    var phoneField = field.form[phoneFieldId];
    if (!phoneField || !phoneField.value) {
        this.showError(id, this.noPhoneText);
        return;
    }
    
    // Show AJAX indicator
    document.getElementById(id+'_ajax_working').style.display = '';
    document.getElementById(id+'_error_block').style.display = 'none';
    document.getElementById(id+'_success_block').style.display = 'none';
    document.getElementById(id+'_send_code').style.display = 'none';
    document.getElementById(id+'_send_code_href').innerHTML = this.resendText;
    
    var self = this;
    new Request.JSON({
        url: this.rootUrl,
        method: 'post',
        data: {
            option: 'com_virtuemart',
            controller: 'virtuemart',
            view: 'virtuemart',
            task: 'smsCheckSend',
            phone: phoneField.value,
            field: id
        },
        onSuccess: function(data, text) {
            document.getElementById(id+'_ajax_working').style.display = 'none';
            document.getElementById(id+'_send_code').style.display = '';
            
            if (data.success) {
                self.showSuccess(id, self.codeSentText);
            }
            else {
                self.showError(id, data.err);
            }
        },
        onError: function(text, error) {
            document.getElementById(id+'_ajax_working').style.display = 'none';
            document.getElementById(id+'_send_code').style.display = '';
            
            self.showError(id, 'Request error');
        },
        onFailure: function(xhr) {
            document.getElementById(id+'_ajax_working').style.display = 'none';
            document.getElementById(id+'_send_code').style.display = '';
            
            self.showError(id, 'Request error');
        }
    }).send();
};
