<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

class VmsmsControllerAjax extends VmsmsController
{
    private function sendError($msg)
    {
        $obj = new stdClass();
        $obj->success = false;
        $obj->err = $msg;
        
        echo json_encode($obj);
        
        $app = JFactory::getApplication();
        $app->close();
    }
    
    private function sendSuccess()
    {
        $obj = new stdClass();
        $obj->success = true;
        
        echo json_encode($obj);
        
        $app = JFactory::getApplication();
        $app->close();
    }
    
    public function send_custom_sms()
    {
        $config = VmsmsConfig::getInstance();
        
        $phone = JRequest::getVar('phone');
        
        // Make sure we don't strip any characters
        $text = JRequest::getVar('text', null, 'default', 'none', 2);
        
        if (empty($config->username) || empty($config->apiKey)) {
            $this->sendError(JText::_('COM_VMSMS_ERR_CREDENTIALS'));
        }
        
        if (empty($phone) || empty($text)) {
            $this->sendError(JText::_('COM_VMSMS_ERR_CUSTOM_SMS_PHONE_TEXT'));
        }
        
        // Try to send the SMS
        $sms = AVmsmsSmsService::getInstance();
        if (!$sms->sendMessage($config->username, $config->apiKey, $phone, $text, $config->allowUnicode, 'vmsms2_custom')) {
            $this->sendError($sms->getError());
        }
        
        $this->sendSuccess();
    }
    
    public function find_phones()
    {
        // Get customers with their phone numbers
        $db = JFactory::getDbo();
        $config = VmsmsConfig::getInstance();
        $req = JRequest::getVar('req', '');
        
        $field1 = $config->primary_phone;
        $field2 = $config->secondary_phone;
        
        $data = array();
        if (!empty($field1) || !empty($field2)) {
            $selects = array();
            $wheres = array();
            
            $selects[] = '`name`';
            $wheres[] = '(`name` LIKE '.$db->quote('%'.$req.'%').')';
            if (!empty($field1)) {
                $selects[] = "`{$field1}` AS `phone1`";
                $wheres[] = "(`{$field1}` LIKE ".$db->quote('%'.$req.'%').")";
            }
            if (!empty($field2)) {
                $selects[] = "`{$field2}` AS `phone2`";
                $wheres[] = "(`{$field2}` LIKE ".$db->quote('%'.$req.'%').")";
            }
            
            $selects = implode(', ', $selects);
            $wheres = implode(' OR ', $wheres);
            
            $query = "SELECT {$selects} FROM `#__virtuemart_userinfos` WHERE {$wheres} ORDER BY `name`";
            $db->setQuery($query);
            $result = $db->loadObjectList();
            
            // Loop through results and create data object for them
            foreach ($result as $info) {
                // Add first phone number
                if (isset($info->phone1) && !empty($info->phone1) && ((stripos($info->name, $req) !== false) || (stripos($info->phone1, $req) !== false))) {
                    $obj = new stdClass();
                    $obj->text = $info->name.'('.$info->phone1.')';
                    $obj->data = $info->phone1;
                    $data[] = $obj;
                }
                
                // Add second phone number
                if (isset($info->phone2) && !empty($info->phone2) && ((stripos($info->name, $req) !== false) || (stripos($info->phone2, $req) !== false))) {
                    $obj = new stdClass();
                    $obj->text = $info->name.'('.$info->phone2.')';
                    $obj->data = $info->phone2;
                    $data[] = $obj;
                }
            }
        }
        
        echo json_encode($data);
        
        $app = JFactory::getApplication();
        $app->close();
    }
}
