<style type="text/css">
    div.docs,
    div.docs p,
    div.docs ul li,
    div.docs ol li {
        text-align: left;
        font-weight: lighter;
        font-family: Tahoma, Arial, Verdana;
    }
    div.docs h1 {
        text-align: center;
    }
	div.docs h4,
	span.h4 {
		color: #CC0000;
		font-weight: bold;
	}
	span.link { cursor: pointer; }
	div.docs p {
		padding-left: 3em;
		font-weight: lighter;
	}
	div.docs .small {
	    color: #666666;
		font-size: 90%;
	}
</style>
<div class="docs">
    <p style="text-align: right;"><span class="small">Updated: 31st of August 2006</span></p>
    <h1>ARTIO JoomSEF v1.2.5 Documentation</h1>
    <p style="text-align: center;"> for Joomla 1.0.x, by <a href="http://www.artio.cz" target="_blank">ARTIO
            s.r.o.</a> </p>
    <h2>Summary</h2>
    <p>Allows Search Engine Friendly URLs for Apache and IIS, returns proper
        404 status code for missing content, provides logging of 404 errors,
        and creation of special &quot;shortcut&quot; URLs that allow the user
        to redirection to the new URL.</p>
    <h2>Changelog</h2>
	<p>
	    <h4>v1.2.5</h4>
		<p> <span class="small">18th September 2006</span>
		<ul>
			<li>Significantly updated JoomFish support</li>
			<li>Added possibility to add language to URL as path or suffix</li>
			<li>Added possibility to translate URLs using JoomFish</li>
			<li>Removed duplicities in URLs (Google indexing optimizaiton)</li>
			<li>Enabled defining of own non-ascii characters rewrite rules</li>
			<li>Fixed number of minor bugs</li>
		</ul>
		</p>
		<h4>v1.2.4</h4>
		<p> <span class="small">31st August 2006</span>
		<ul>
			<li>Documentation update.</li>
			<li>Prevented loadClass error problem with older Joomla! versions.</li>
		</ul>
		</p>
		<h4>v1.2.3</h4>
		<p> <span class="small">29th August 2006</span>
		<ul>
			<li>Compatibility fix with URLs using numeric entities (e.g. generated
				by JCE WYSIWG editor).</li>
		</ul>
		</p>
		<h4>v1.2.2</h4>
		<p> <span class="small">28th August 2006</span>
		<ul>
			<li>Security fixes to match Joomla 1.0.11 requirements and minor bugs
				coorections.</li>
		</ul>
		</p>
		<h4>v1.2b</h4>
		<p> <span class="small">15th August 2006</span>
		<ul>
			<li>Fixed pagination problems.</li>
			<li>Integrated JoomFish and DocMan support.</li>
			<li>Ported from 404SEFx.</li>
		</ul>
		</p>
	</p>
    <h2>Documentation</h2>
    <ol style="list-style-type: upper-roman;">
        <li>
            <h3>Introduction</h3>
            <p>This documents describes how to install and setup ARTIO JoomSEF Joomla!
			component.
                You can view this documentation again by selecting the &qout;ARTIO
                JoomSEF Documentation&qout; button from the ARTIO JoomSEF Control
                Panel.</p>
        </li>
        <li>
            <h3>Installation Instructions</h3>
            <p>You can view installation instructions below by clicking the appropriate
                arrow.</p>
            <p>If your .htaccess file was set as writable the install may have
                updated it already and you shouldn't have to worry about it.</p>
            <p>If your site is in a subdirectory be sure to change the RewriteBase
                line accordingly. ex/ RewriteBase /joomla</p>
            <ol style="list-style-type: decimal;" id="collapsibleList">
                <li>
                    <script type="text/javascript">
						document.writeln('<span id="imgInstall" class="link" title="Open list" onClick="toggle(\'imgInstall\',\'install\');"><strong>+</strong></span>');
					</script>
                    <span class="h4 link" onClick="toggle('imgInstall','install');">Installation</span><br />
                    <ul id="install" style="list-style: none;">
                        <li>
                            <ol>
                                <li>Upload the zip file to Joomla! using
                                    the component installer in the usual way.</li>
                                <li>For apache, set your &quot;.htaccess&quot; file
                                    like this:<br />
                                    <pre>
        ##
        # @version $Id: htaccess.txt 2368 2006-02-14 17:40:02Z stingrey $
        # @package Joomla
        # @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
        # @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
        # Joomla! is Free Software
        ##


        #####################################################
        #  READ THIS COMPLETELY IF YOU CHOOSE TO USE THIS FILE
        #
        # The line just below this section: 'Options FollowSymLinks' may cause problems
        # with some server configurations.  It is required for use of mod_rewrite, but may already
        # be set by your server administrator in a way that dissallows changing it in
        # your .htaccess file.  If using it causes your server to error out, comment it out (add # to
        # beginning of line), reload your site in your browser and test your sef url's.  If they work,
        # it has been set by your server administrator and you do not need it set here.
        #
        # Only use one of the two SEF sections that follow.  Lines that can be uncommented
        # (and thus used) have only one #.  Lines with two #'s should not be uncommented
        # In the section that you don't use, all lines should start with #
        #
        # For Standard SEF, use the standard SEF section.  You can comment out
        # all of the RewriteCond lines and reduce your server's load if you
        # don't have directories in your root named 'component' or 'content'
        #
        # If you are using a 3rd Party SEF or the Core SEF solution
        # uncomment all of the lines in the '3rd Party or Core SEF' section
        #
        #####################################################

        #####  SOLVING PROBLEMS WITH COMPONENT URL's that don't work #####
        # SPECIAL NOTE FOR SMF USERS WHEN SMF IS INTEGRATED AND BRIDGED
        # OR ANY SITUATION WHERE A COMPONENT's URL's AREN't WORKING
        #
        # In both the 'Standard SEF', and '3rd Party or Core SEF' sections the line:
        # RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] ##optional - see notes##
        # May need to be uncommented.  If you are running your Joomla! from
        # a subdirectory the name of the subdirectory will need to be inserted into this
        # line.  For example, if your Joomla! is in a subdirectory called '/test/',
        # change this:
        # RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] ##optional - see notes##
        # to this:
        # RewriteCond %{REQUEST_URI} ^(/test/component/option,com) [NC,OR] ##optional - see notes##
        #
        #####################################################


        ##  Can be commented out if causes errors, see notes above.
        Options FollowSymLinks

        #
        #  mod_rewrite in use

        RewriteEngine On


        #  Uncomment following line if your webserver's URL
        #  is not directly related to physical file paths.
        #  Update Your Joomla! Directory (just / for root)

        # RewriteBase /


        ########## Begin Standard SEF Section
        ## ALL (RewriteCond) lines in this section are only required if you actually
        ## have directories named 'content' or 'component' on your server
        ## If you do not have directories with these names, comment them out.
        #
        #RewriteCond %{REQUEST_FILENAME} !-f
        #RewriteCond %{REQUEST_FILENAME} !-d
        #RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] 		##optional - see notes##
        #RewriteCond %{REQUEST_URI} (/|\.htm|\.php|\.html|/[^.]*)$  [NC]
        #RewriteRule ^(content/|component/) index.php
        #
        ########## End Standard SEF Section


        ########## Begin 3rd Party or Core SEF Section
        #
        #RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] 		##optional - see notes##
        RewriteCond %{REQUEST_URI} (/|\.htm|\.php|\.html|/[^.]*)$  [NC]
        RewriteCond %{REQUEST_FILENAME} !-f
        RewriteCond %{REQUEST_FILENAME} !-d
        RewriteRule (.*) index.php
        #
        ########## End 3rd Party or Core SEF Section

        			</pre>
                                </li>
                                <li>For IIS, see Configuring IIS.</li>
                                <li>Ensure that SEF is enabled under Global Configuration
                                    in the Joomla! backend.</li>
                                <li> Edit the 404 SEF configuration, Change Enable
                                    to yes and save.<br />
                                    This is neccessary to ensure the default
                                    404 document gets saved to the Joomla!
                                    database. </li>
                            </ol>
							<br />
                        </li>
                    </ul>
                </li>
                <li>
                    <script type="text/javascript">
						document.writeln('<span id="imgIIS" class="link" title="Open list" onClick="toggle(\'imgIIS\',\'iis\');"><strong>+</strong></span>');
					</script>
                    <span class="h4 link" onClick="toggle('imgIIS','iis');">Configuring IIS</span><br />
                    <ul id="iis" style="list-style: none">
                        <li>
                            <ol>
                                <li>
                                    <h4>Install ActiveScript</h4>
                                    After installing PHP, you should download
                                    the ActiveScript DLL (php4activescript.dll)
                                    and place it in the main PHP folder (e.g.
                                    C:\php).<br/>
                                    <br/>
                                    After having all the files needed, you must
                                    register the DLL on your system. To achieve
                                    this, open a Command Prompt window (located
                                    in the Start Menu). Then go to your PHP directory
                                    by typing something like cd C:\php. To register
                                    the DLL just type
                                    <pre>regsvr32 php4activescript.dll</pre>
                                </li>
                                <li>
                                    <h4>Install .NET framework 1.1</h4>
                                    To the best of my limited knowledge of IIS,
                                    this is required for web.config to work,
                                    so install it<br/>
                                    <br/>
                                </li>
                                <li>
                                    <h4>Create/Modify web.config</h4>
                                    <span style="color: red; font-weight: bold;">NOTE:
                                    in the example below, Joomla! is installed
                                    in the virtual directory 'joomla'.</span><br/>
                                    <br/>
                                    Create C:\Inetpub\wwwroot\web.config and
                                    add the content below:<br />
                                    <pre>&lt;?xml version=&quot;1.0&quot; encoding=&quot;utf-8&quot;?&gt;
        &lt;configuration&gt;
        	&lt;system.web&gt;
        		&lt;compilation defaultLanguage=&quot;PHP4Script&quot; debug=&quot;true&quot; /&gt;
        		&lt;customerrors mode=&quot;On&quot; defaultRedirect=&quot;/joomla/index.php&quot; /&gt;
        	&lt;/system.web&gt;
        &lt;/configuration&gt;</pre>
                                </li>
                                <li>
                                    <h4>Configure the Custom Errors</h4>
                                    <span style="color: red; font-weight: bold;">NOTE:
                                    in the example below, Joomla! is installed
                                    in the virtual directory Joomla!</span>
                                    <pre>Using the Internet Services Manager, right-click the directory in which Joomla! is installed.
							Select properties >> Custom Error
							set the 404 to URL:/joomla/index.php
							set the 405 to URL:/joomla/index.php</pre>
                                </li>
                            </ol>
							<br />
                        </li>
                    </ul>
                </li>
                <li>
                    <script type="text/javascript">
						document.writeln('<span id="imgUninstall" class="link" title="Open list" onClick="toggle(\'imgUninstall\',\'uninstall\');"><strong>+</strong></span>');
					</script>
                    <span class="h4 link" onClick="toggle('imgUninstall','uninstall');">Uninstall</span><br />
                    <ul id="uninstall" style="list-style: none;">
                        <li>
                            <ol>
                                <li>Uninstall the component using the component
                                    unistaller in the usual way.</li>
                                <li>For apache, set your &quot;.htaccess&quot; like
                                    this :<br />
                                    <pre>
        ##
        # @version $Id: htaccess.txt 2368 2006-02-14 17:40:02Z stingrey $
        # @package Joomla
        # @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
        # @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
        # Joomla! is Free Software
        ##


        #####################################################
        #  READ THIS COMPLETELY IF YOU CHOOSE TO USE THIS FILE
        #
        # The line just below this section: 'Options FollowSymLinks' may cause problems
        # with some server configurations.  It is required for use of mod_rewrite, but may already
        # be set by your server administrator in a way that dissallows changing it in
        # your .htaccess file.  If using it causes your server to error out, comment it out (add # to
        # beginning of line), reload your site in your browser and test your sef url's.  If they work,
        # it has been set by your server administrator and you do not need it set here.
        #
        # Only use one of the two SEF sections that follow.  Lines that can be uncommented
        # (and thus used) have only one #.  Lines with two #'s should not be uncommented
        # In the section that you don't use, all lines should start with #
        #
        # For Standard SEF, use the standard SEF section.  You can comment out
        # all of the RewriteCond lines and reduce your server's load if you
        # don't have directories in your root named 'component' or 'content'
        #
        # If you are using a 3rd Party SEF or the Core SEF solution
        # uncomment all of the lines in the '3rd Party or Core SEF' section
        #
        #####################################################

        #####  SOLVING PROBLEMS WITH COMPONENT URL's that don't work #####
        # SPECIAL NOTE FOR SMF USERS WHEN SMF IS INTEGRATED AND BRIDGED
        # OR ANY SITUATION WHERE A COMPONENT's URL's AREN't WORKING
        #
        # In both the 'Standard SEF', and '3rd Party or Core SEF' sections the line:
        # RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] ##optional - see notes##
        # May need to be uncommented.  If you are running your Joomla! from
        # a subdirectory the name of the subdirectory will need to be inserted into this
        # line.  For example, if your Joomla! is in a subdirectory called '/test/',
        # change this:
        # RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] ##optional - see notes##
        # to this:
        # RewriteCond %{REQUEST_URI} ^(/test/component/option,com) [NC,OR] ##optional - see notes##
        #
        #####################################################


        ##  Can be commented out if causes errors, see notes above.
        Options FollowSymLinks

        #
        #  mod_rewrite in use

        RewriteEngine On


        #  Uncomment following line if your webserver's URL
        #  is not directly related to physical file paths.
        #  Update Your Joomla! Directory (just / for root)

        # RewriteBase /


        ########## Begin Standard SEF Section
        ## ALL (RewriteCond) lines in this section are only required if you actually
        ## have directories named 'content' or 'component' on your server
        ## If you do not have directories with these names, comment them out.
        #
        RewriteCond %{REQUEST_FILENAME} !-f
        RewriteCond %{REQUEST_FILENAME} !-d
        #RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] 		##optional - see notes##
        RewriteCond %{REQUEST_URI} (/|\.htm|\.php|\.html|/[^.]*)$  [NC]
        RewriteRule ^(content/|component/) index.php
        #
        ########## End Standard SEF Section


        ########## Begin 3rd Party or Core SEF Section
        #
        #RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR] 		##optional - see notes##
        #RewriteCond %{REQUEST_URI} (/|\.htm|\.php|\.html|/[^.]*)$  [NC]
        #RewriteCond %{REQUEST_FILENAME} !-f
        #RewriteCond %{REQUEST_FILENAME} !-d
        #RewriteRule (.*) index.php
        #
        ########## End 3rd Party or Core SEF Section


						</pre>
                                </li>
                                <li>For IIS, remove C:\Inetpub\wwwroot\web.config
                                    and<br />
                                    the Custom Errors you created with the Internet
                                    Services Manager<br />
                                </li>
                            </ol>
							<br />
                        </li>
                    </ul>
                </li>
                <li>
                    <h4>Configuration checklist</h4>
                    <p>Make sure that:</p>
                    <p><ol>
                        <li>the .htaccess exists in the root of your Joomla! site</li>
                        <li>the 3rd party section rules in .htaccess are uncommented</li>
                        <li>the &quot;RewriteBase&quot; rule matches YOUR Joomla! installation</li>
                        <li>Joomla! SEF is &quot;ON&quot; in site &quot;Global configuration&quot;</li>
                        <li>JoomSEF is &quot;ON&quot; in site &quot;JoomSEF configuration&quot;</li>
                    </ol>
                    </p>
                </li>
            </ol>
        </li>
        <li>
            <h3>Useful Tips For Using ARTIO JoomSEF</h3>
            <ul style="list-style: none;">
            <li>
            <h4>Configuration</h4>
            <p>Using the ARTIO JoomSEF configuration is fairly straight forward.
                For more information on each item hover your mouse over the blue
                (i) images when you are in the configuration screen.</p>
            <p>When you save the configuration it will remove all your URL's
                from the database. If you have a high traffic site it may be
                wise to put it offline before saving the ARTIO JoomSEF config
                or purging the database and go and browse your site starting
                at the main page. This will create the URL's properly for you
                and prevent numbers from being added to the ends of URL's people
                were browsing that changed.</p>
            <p>You may want to purge the 404 log before creating fresh urls.</p>
            </li>
            <li>
            <h4>Modifying URL's</h4>
            <p>You can modify URL's to your liking. Go into the ARTIO JoomSEF
                Control Panel and click ' View/Edit SEF Urls'. Select the URL
                you wish to modify. If you click the check box labeled 'Save
                as Custom Redirect' it will place this URL into the 'Custom Redirect'
                area which you can navigate to from the ARTIO JoomSEF Control
                Panel. When you click 'View/Edit Custom Redirects' you will see
                your URL in here now instead. These urls will not be removed
                when you save the config. You can modify these and save them
                as you wish.
            <p>This is particularly useful if you are updating from an old site
                because any URL's that are no longer availble will be logged.
                You can view these URL's by clicking 'View/Edit 404 Logs' in
                the ARTIO JoomSEF Control Panel. You can redirect visitors to
                the new page by selecting the URL you wish to modify and entering
                the new url. Note: The ability to enter non-Joomla! URL's into
                this area is coming soon! This will allow you to easily transfer
                a non-Joomla! site to Joomla using ARTIO JoomSEF and any of your
                old URL's will be redirected to the new page within Joomla!.</p>
            </li>
            <li>
            <h4>Backing up your URL's</h4>
            <p>It is recommended to backup your database before doing this.</p>
            <p>You can also import and export URL's from the Custom Redirect
                area. To do this click the 'Import/Export Custom URLS' link above
                the table of URL's. To backup your URL's click the 'Backup Custom
                URLS' button and you will be presented with a file named 'ARTIO
                JoomSEF_custom_urls.sql' to download.</p>
            <p>If you want to import your urls browse to the file and click the
                'Import Custom URLS' button.</p>
                </ul>
            </li>
        </li>
		<li>
            <h3>Support & Help</h3>
            <p>If you need more help with the ARTIO JoomSEF component, visit our webpages at <a href="http://www.artio.cz">http://www.artio.cz</a>
			and check our FAQs & support forums.
			</p>
        </li>
    </ol>
    <script type="text/javascript">
		document.getElementById('collapsibleList').style.listStyle = "none"; // remove list markers
		document.getElementById('install').style.display = "none"; // collapse list
		document.getElementById('iis').style.display = "none"; // collapse list
		document.getElementById('uninstall').style.display = "none"; // collapse list
		// this function toggles the status of a list
		function toggle(image,list){
			var listElementStyle = document.getElementById(list).style;
			if (listElementStyle.display == "none"){
				listElementStyle.display = "block";
				document.getElementById(image).innerHTML = '<strong>-</strong>';
				document.getElementById(image).title = "Close list";
			}
			else {
				listElementStyle.display = "none";
				document.getElementById(image).innerHTML = '<strong>+</strong>';
				document.getElementById(image).title = "Open list";
			}
		}
	</script>
    <div class="small" style="text-align: center;">
        Copyright &copy; 2004-2006 ARTIO s.r.o., W. H. Welch<br />
        Distributed under the terms of the GNU General Public License.
    </div>
</div>
