<?php
/**
 * ReMOSitory SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

global $mosConfig_absolute_path, $mosConfig_lang, $mosConfig_sitename, $mosConfig_live_site;

require_once($mosConfig_absolute_path.'/components/com_remository/com_remository_settings.php');
if( file_exists($mosConfig_absolute_path.'/components/com_remository/language/'.$mosConfig_lang.'.php') )
    require_once($mosConfig_absolute_path.'/components/com_remository/language/'.$mosConfig_lang.'.php');
if( ($mosConfig_lang != 'english') && file_exists($mosConfig_absolute_path.'/components/com_remository/language/english.php') )
    require_once($mosConfig_absolute_path.'/components/com_remository/language/english.php');

// Creates an array of nested containers for given container id
if( !function_exists('joomsefRemositoryGetContainers')) {
    function joomsefRemositoryGetContainers($id) {
        global $database;
            
        $containers = array();
        while ($id > 0) {
            $database->setQuery("SELECT `name`, `parentid` FROM `#__downloads_containers` WHERE `id` = $id");
            $row = $database->loadRow();
            array_unshift ($containers, $row[0]);
            $id = $row[1];
        }
        return $containers;
    }
}

// Returns path to given file id
if( !function_exists('joomsefRemositoryGetFilePath')) {
    function joomsefRemositoryGetFilePath($id) {
        global $database;
        
        $database->setQuery("SELECT `filetitle`, `containerid` FROM `#__downloads_files` WHERE `id` = $id");
        $row = $database->loadRow();
        $path = joomsefRemositoryGetContainers($row[1]);
        array_push($path, $row[0]);
        
        return $path;
    }
}

// Extract variables
extract($vars);
$title = array();

$title[] = getMenuTitle(@$option, @$task, @$Itemid);

if( isset($func) ) {
    switch( $func ) {
        case 'select':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetContainers($id));
            break;
            
        case 'addfile':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetContainers($id));
            $title[] = _SUBMIT_FILE_BUTTON;
            break;
            
        case 'search':
            $title[] = _DOWN_SEARCH;
            break;
            
        case 'addmanyfiles':
            $title[] = _DOWN_ADD_NUMBER_FILES;
            break;
            
        case 'fileinfo':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetFilePath($id));
            break;
            
        case 'thumbupdate':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetFilePath($id));
            $title[] = _DOWN_UPDATE_THUMBNAILS;
            break;
            
        case 'userupdate':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetFilePath($id));
            $title[] = _DOWN_UPDATE_SUB;
            break;
            
        case 'rss':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetContainers($id));
            $title[] = 'rss';
            break;
            
        case 'download':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetFilePath($id));
            $title[] = 'get';
            break;

        case 'startdown':
            if( isset($id) )
                $title = array_merge($title, joomsefRemositoryGetFilePath($id));
            $title[] = _DOWNLOAD;
            break;
    }
}

if (count($title) > 0) {
    $nonSefVars = array();
    if( isset($orderby) ) $nonSefVars['orderby'] = $orderby;
    if( isset($no_html) ) $nonSefVars['no_html'] = $no_html;
    if( isset($chk) ) $nonSefVars['chk'] = $chk;
    if( isset($fname) ) $nonSefVars['fname'] = $fname;
    $string = sef_404::sefGetLocation($string, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars);
}
?>