<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 * @license     Released under the terms of the GNU General Public License
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

$_MAMBOTS->registerFunction('onAfterStart', 'initMetaBot');
$_MAMBOTS->registerFunction('beforeHead', 'checkSEFTitle');
$_MAMBOTS->registerFunction('beforeHead', 'generateSEFMeta');

function initMetaBot()
{
    $metabot = getMetaBot();
    
    // if published
    if ($metabot->published) {

        // define own mainframe class
        class metaMainFrame extends mosMainFrame
        {
            
            function getHead()
            {
                global $_MAMBOTS;
    
                $_MAMBOTS->trigger('beforeHead');
                return parent::getHead();
            }
            
        }
    
        // now redefine mainframe
        global $mainframe, $option;
        $myframe = new metaMainFrame(&$mainframe->_db, $option, '.');
        
        foreach (get_object_vars($mainframe) as $key => $value) {
            $myframe->$key = &$mainframe->$key;
        }
        //unset($mainframe);
        $mainframe = null;
        $mainframe = $myframe;
    }
}
        
function getMetaBot()
{
    static $metabot;

    // load params from DB
    if (is_null($metabot)) {
        global $database;

        // Get the mambot's parameters
        $query = "SELECT id FROM #__mambots WHERE element = 'joomsef_metabot' AND folder = 'system'";
        $database->setQuery($query);
        $id = $database->loadResult();
        $metabot = new mosMambot($database);
        $metabot->load($id);
    }

    return $metabot;    
    
}

function getMetaBotParams()
{
    $metabot = getMetaBot();
    return new mosParameters($metabot->params);
}

function checkSEFTitle()
{
    global $mainframe;

    $params = getMetaBotParams();
    $preferTitle = $params->get('prefer_joomsef_title');
    $useSitename = $params->get('use_sitename');
    $sitenameSep = $params->get('sitename_sep');

    // Page title
    $pageTitle = isset($GLOBALS['sefMetaTags']['title'])
    ? $GLOBALS['sefMetaTags']['title']
    : strtr($mainframe->getPageTitle(), 
        array(
            $GLOBALS['mosConfig_sitename'].' - ' => '', 
            $GLOBALS['mosConfig_sitename'] => '', 
            ' - ' => '', 
            $sitenameSep => ''
        )
    );

    if ($preferTitle || @$GLOBALS['mosConfig_pagetitles']) {
        $pageTitle = trim($pageTitle);

        if (empty($pageTitle)) $sitenameSep = '';
        if ($useSitename == 1 && $GLOBALS['mosConfig_sitename']) {
            $pageTitle = $GLOBALS['mosConfig_sitename'].$sitenameSep.$pageTitle;
        }
        elseif ($useSitename == 2 && $GLOBALS['mosConfig_sitename']) {
            $pageTitle .= $sitenameSep.$GLOBALS['mosConfig_sitename'];
        }

        // set page title
        if ($pageTitle) {
            $mainframe->_head['title'] = ($pageTitle);
            if ($preferTitle) {
                // Protect our title from rewriting
                $GLOBALS['mosConfig_pagetitles'] = '0';
            }
        }
        // clear used variable
        if (isset($tags['title'])) unset($tags['title']);
    }
}

function generateSEFMeta()
{
    global $mainframe, $mosConfig_MetaKeys, $mosConfig_MetaDesc;

    $params = getMetaBotParams();
    $rewriteKeywords    = $params->get('rewrite_keywords');
    $rewriteDescription = $params->get('rewrite_description');

    if (isset($GLOBALS['sefMetaTags'])) {
        // set alias
        $tags = $GLOBALS['sefMetaTags'];

        // Description metatag
        if (isset($tags['metadesc'])) {
            if( ($rewriteDescription == '1') || ($mosConfig_MetaDesc == '') ) {
                $mosConfig_MetaDesc = $tags['metadesc'];
            }
            else {
                $mosConfig_MetaDesc .= ', ' . $tags['metadesc'];
            }
            //$mainframe->addMetaTag('description', $mosConfig_MetaDesc);
            //$mosConfig_MetaDesc = '';
            unset($tags['metadesc']);
        }

        // Keywords metatag
        if (isset($tags['metakey'])) {
            if( ($rewriteKeywords == '1') || ($mosConfig_MetaKeys == '') ) {
                $mosConfig_MetaKeys = $tags['metakey'];
            }
            else {
                $mosConfig_MetaKeys .= ', ' . $tags['metakey'];
            }
            //$mainframe->addMetaTag('keywords', $mosConfig_MetaKeys);
            //$mosConfig_MetaKeys = '';
            unset($tags['metakey']);
        }

        // Other metatags
        foreach ($tags as $name => $content) {
            $mainframe->appendMetaTag($name, $content);
        }
    }
}
?>
