<?php
/**
 * Contacts SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

class sefext_com_contact extends sef_joomsef
{
    var $params;

    function getCategoryTitle($id) {
        global $database;

        $database->setQuery("SELECT `id`, `title` FROM `#__categories` WHERE `id` = $id");
        $database->loadObject($cat);
        if($cat) {
            $name = ( ($this->params->get('categoryid', '0') != '0') ? $id.'-' : '' ).$cat->title;
            return $name;
        } else {
            return null;
        }
    }

    function getContactName($id) {
        global $database;

        $database->setQuery("SELECT `id`, `name`, `catid` FROM `#__contact_details` WHERE `id` = $id");
        $database->loadObject($contact);
        if($contact) {

            $name = ( ($this->params->get('contactid', '0') != '0') ? $id.'-' : '' ).$contact->name;

            if( $this->params->get('category', '1') != '1' ) {
                return array( $name );
            } else {
                return array( $this->getCategoryTitle($contact->catid), $name );
            }
        }
        else {
            return array();
        }
    }

    function beforeCreate($string, &$vars) {
        // Remove the part after ':' from variables
        if( !empty($vars['id']) )       SEFTools::fixVariable($vars['id'], $string);
        if( !empty($vars['catid']) )    SEFTools::fixVariable($vars['catid'], $string);
        
        // Remove view and catid if they point to empty category
        if( !empty($vars['view']) && ($vars['view'] == 'category') ) {
            if( !isset($vars['catid']) || ($vars['catid'] == 0) ) {
                $string = SEFTools::RemoveVariable($string, 'view');
                if( isset($vars['catid']) ) {
                    $string = SEFTools::RemoveVariable($string, 'catid');
                }
            }
        }

        return $string;
    }

    function create($string, &$vars) {
        global $mosConfig_absolute_path;

        // Extract variables
        extract($vars);
        $title = array();

        $this->params = SEFTools::getExtParams('com_contact');

        $title[] = getMenuTitle(@$option, @$task, @$Itemid);

        if( isset($view) ) {
            switch($view) {
                case 'contact':
                    $title = array_merge( $title, $this->getContactName($id) );
                    unset($view);
                    break;

                case 'category':
                    if( isset($catid) ) {
                        $title[] = $this->getCategoryTitle($catid);
                    }
                    unset($view);
                    break;
            }
        }

        if( !empty($format) && ($format == 'feed') ) {
            if( !empty($type) ) $title[] = $type;
        }

        if (count($title) > 0) {
            $string = sef_joomsef::sefGetLocation($string, $title, @$view, null, null, @$lang);
        }

        return $string;
    }
}
?>