<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocuments */

$config = JoomDOCConfig::getInstance();

// global setting for all items
$showFileDates = $config->showCreated || $config->showModified;
$showFileInfo = $config->showFilesize || $config->showHits;
$showAllDesc = $config->showFolderDesc && $config->showFileDesc;

// quick informations about root
$rootDocId = JoomDOCHelper::getDocumentID($this->root);
$rootRelativePath = $this->root->getRelativePath();
$rootAbsolutePath = $this->root->getAbsolutePath();
$rootAlias = JoomDOCHelper::getDocumentAlias($this->root);

?>
<form action="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($rootRelativePath, $rootAlias)); ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
	<div id="documents">
		<?php 
			// if path is not root display back link
			if (!$this->inRoot && $rootRelativePath) { 
				$parentAlias = $this->root->parent ? $this->root->parent->full_alias : null; 
		?>
				<a class="back" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments(JoomDOCFileSystem::getParentPath($rootRelativePath), $parentAlias)); ?>" title=""><?php echo JText::_('JOOMDOC_BACK'); ?></a>
		<?php 
			} 
			// in root display default title if root hasn't document			
			if ($this->inRoot && !$rootDocId && $config->defaultTitle) {
		?>
				<h1><?php echo $config->defaultTitle; ?></h1>
		<?php 
			// otherwise display document title or path as title
			} else { 
		?>
				<h1><?php echo $rootDocId ? $this->root->document->title : $rootRelativePath; ?></h1>
		<?php 
			}
			// in root display default description if root hasn't document
			if ($this->inRoot && !$rootDocId && $config->defaultDescription) { 
		?>
				<p><?php echo $config->defaultDescription; ?></p>
		<?php 
			// otherwise display document description if available
			} elseif ($rootDocId && ($description = JString::trim($this->root->document->description))) { 
		?>
				<p><?php echo $description; ?></p>
		<?php 
			}
			if (JoomDOCAccessFileSystem::uploadFile($rootDocId, $rootRelativePath)) {
		?>		
				<div class="upload">
					<label for="upload" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_UPLOADFILE'); ?>">
						<?php echo JText::_('JOOMDOC_DOCUMENTS_UPLOADFILE'); ?>
					</label>			
					<input type="file" name="upload" id="upload" />
					<input type="checkbox" name="iszip" id="iszip" value="1" />
					<label for="iszip" title="">
						<?php echo JText::_('JOOMDOC_DOCUMENTS_UNPACK_ZIP'); ?>
					</label>
					<button type="submit" onclick="return JoomDOC.upload(this)">
						<?php echo JText::_('JOOMDOC_UPLOAD'); ?>
					</button>
				</div>
		<?php			
			}
			
			$this->root->initIteration();
		
			// check if document allow display files without documents
			$filesWithouDoc = true;
			if ($rootDocId) {
				$params = new JRegistry($this->root->document->params);
				$filesWithouDoc = (int) $params->getValue('files_without_doc', 1);
			}
			
			$class = null;
			
			if (! $this->root->hasNext()) {
			?>
				<p class="empty"><?php echo JText::_('JOOMDOC_EMPTY_FOLDER'); ?></p>
			<?php
			}
			
			$files = $folders = array();
			
			while ($this->root->hasNext()) {
				
				$item = $this->root->getNext();
				
				$docid = JoomDOCHelper::getDocumentID($item);
				
				$isFolder = JoomDOCFileSystem::isFolder($item);
				$isFile = JoomDOCFileSystem::isFile($item);
				
				$relativePath = $item->getRelativePath();
				$absolutePath = $item->getAbsolutePath();
				
				/* looking for available tools */
				
				// control if item si folder and can be entried
				$canEntry = !$isFolder || JoomDOCAccessFileSystem::enterFolder($docid, $relativePath);
						
				// tools affected with component global config
				$canOpenFolder = $isFolder && $config->showOpenFolder && $canEntry;
				$canOpenFile = $isFile && $config->showOpenFile;
						
				// tools affected by document permissions
				$canEditDocument = $docid && JoomDOCAccessDocument::canEdit($item->document);
				$canDeleteDocument = $docid && JoomDOCAccessDocument::delete($docid);
				$canPublishDocument = $docid && JoomDOCAccessDocument::editState($docid, $item->document->checked_out);
						
				// tools for files which can be without document (access are inherit) 
				$canAddDocument = !$docid && JoomDOCAccessDocument::create($relativePath);
				$canDeleteFile = JoomDOCAccessFileSystem::deleteFile($docid, $relativePath);
				$canDownloadFile = $isFile && $config->showDownloadFile && JoomDOCAccessFileSystem::download($docid, $relativePath);
				$canViewFileInfo = JoomDOCAccessFileSystem::viewFileInfo($docid, $relativePath);
				
				// logged user can do any edit operation
				$canEdit = $canEditDocument || $canDeleteDocument || $canPublishDocument || $canAddDocument || $canDeleteFile || $canDeleteDocument;
				
				// save files/folders names for next using
				$isFile ? $files[] = $item->getFileName() : $folders[] = $item->getFileName();
				
				// no subfolders
				if ($isFolder && ! $config->showSubfolders)
					continue;
		
				// no display files without doc	
				if (! $docid && (! $filesWithouDoc || ! $config->filesWithoutDoc))
					continue;
				
				// document is unpublish and user cannot edit document	
				if ($docid && $item->document->published == JOOMDOC_STATE_UNPUBLISHED && !$canEdit)
					continue;
					
				if ($config->showFileicon)
					$class = $isFile ? JoomDOCHelper::getFileIconClass($relativePath) : 'folder';
					
				// document alias for SEF URL		
				$alias = JoomDOCHelper::getDocumentAlias($item);
				// url to open item detail
				$viewDocuments = JRoute::_(JoomDOCRoute::viewDocuments($relativePath, $alias));
				
				// document has favorite mark
				$isFavorite = $docid && $item->document->favorite == 1;
				$displayFavorite = $isFavorite && $config->displayFavorite;
		?>
				<div class="document<?php if ($isFavorite) { ?> favorite<?php } ?>">
				
					<h2<?php if ($class) { ?> class="icon <?php echo $class; ?>"<?php } ?>>
						<?php 
							if ($canEntry) { 
						?>
								<a href="<?php echo $viewDocuments; ?>" title="">
						<?php 
							} 
							// as item title use document title or file name
							echo $docid ? $item->document->title : $item->getFileName();
							if ($canEntry) { 
						?>
								</a>
						<?php 
							} 
						?>
					</h2>
					
					<?php 
						if ($canViewFileInfo && (($docid && $showFileDates) || (! $isFolder && $showFileInfo) || $displayFavorite)) { 
					?>
							<div class="info">
								<?php 
									if ($displayFavorite) {
								?>
										<span class="favorite"><?php echo JText::_('JOOMDOC_FAVORITE'); ?></span>
								<?php	
									}
								?>
							
								<?php 
									if ($config->showFilesize && ! $isFolder) { 
								?>
										<span class="filesize"><?php echo JText::sprintf('JOOMDOC_FILESIZE', JoomDOCFileSystem::getFileSize($absolutePath)); ?></span>
								<?php 
									} 
									if ($docid) {
										if ($config->showCreated) {
								?>
											<span class="created"><?php echo JText::sprintf('JOOMDOC_CREATED', JHtml::date($item->document->created, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
								<?php	
										}
										if ($config->showModified && JoomDOCHelper::canViewModified($item->document->created, $item->document->modified)) {
								?>
											<span class="modified"><?php echo JText::sprintf('JOOMDOC_MODIFIED', JHtml::date($item->document->modified, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
								<?php 
										}
									}
									if ($config->showHits && ! $isFolder) {
								?>
										<span class="hits"><?php echo JText::sprintf('JOOMDOC_HITS_INFO', JoomDOCHelper::number($item->hits)); ?></span>
								<?php		
									}
								?>
								<div class="clr"></div>
							</div>
					<?php 
						}
						
						if ($docid && ($description = JString::trim($item->document->description)) && ($showAllDesc || ($isFolder && $config->showFolderDesc) || ($isFile && $config->showFileDesc))) {
					?>
							<p><?php echo JoomDOCString::crop($description, 200); ?></p>
					<?php 
						}
						
						if ($canOpenFolder || $canOpenFile || $canDeleteDocument || $canEditDocument || $canAddDocument || $canDeleteFile || $canDownloadFile) {
					?>	
							<div class="toolbar">
								<?php 
									if ($canOpenFolder) { 
								?>
										<a class="open" href="<?php echo $viewDocuments; ?>" title=""><?php echo JText::_('JOOMDOC_DISPLAY_FOLDER'); ?></a>
								<?php 
									}
									if ($canOpenFile) {  
								?>
										<a class="open" href="<?php echo $viewDocuments; ?>" title=""><?php echo JText::_('JOOMDOC_DISPLAY_FILE'); ?></a>
								<?php 
									}
									if ($canDownloadFile) { 
								?>
										<a class="download" href="<?php echo JRoute::_(JoomDOCRoute::download($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_DOWNLOAD_FILE'); ?></a>
						
								<?php 
									} 
									if ($canAddDocument) { 
								?>
										<a class="add" href="<?php echo JRoute::_(JoomDOCRoute::add($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_ADD_DOCUMENT'); ?></a>
								<?php 
									} 
									if ($canEditDocument) { 
								?>
										<a class="edit" href="<?php echo JRoute::_(JoomDOCRoute::edit($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_EDIT_DOC'); ?></a>
								<?php
									}
									if ($canPublishDocument) {
										if ($item->document->state == JOOMDOC_STATE_UNPUBLISHED) {
								?>		
											<a class="publish" href="<?php echo JRoute::_(JoomDOCRoute::publish($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_PUBLISH'); ?></a>
								<?php 
										} elseif ($item->document->state == JOOMDOC_STATE_PUBLISHED) {
								?>		
											<a class="unpublish" href="<?php echo JRoute::_(JoomDOCRoute::unpublish($relativePath, $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_UNPUBLISH'); ?></a>
								<?php		 
										}
									}
									if ($canDeleteFile) { 
								?>
										<a class="delete" href="javascript:void(0)" onclick="JoomDOC.confirm('<?php echo addslashes(JRoute::_(JoomDOCRoute::deletefile($relativePath, $alias))); ?>')" title=""><?php echo JText::_('JOOMDOC_DELETE_ITEM'); ?></a>
						
								<?php 
									}
									if ($canDeleteDocument) { 
								?>
										<a class="deleteDocument" href="javascript:void(0)" onclick="JoomDOC.confirm('<?php echo addslashes(JRoute::_(JoomDOCRoute::delete($relativePath, $alias))); ?>')" title=""><?php echo JText::_('JOOMDOC_DELETE_DOCUMENT'); ?></a>
						
								<?php 
									}
								?>								
								<div class="clr"></div>
							</div>
					<?php 
						} 
					?>
				</div>
		<?php		
			}
		?>
	</div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" id="joomdocToken" name="<?php echo JUtility::getToken(); ?>" value="1" />
</form>
<?php 
	JoomDOCHelper::jsArray('joomDOCFiles', $files);
	JoomDOCHelper::jsArray('joomDOCFolders', $folders);
?>