<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

class JHtmlJoomDOC {
    /**
     * Display icon tool to set item as default or non default.
     *
     * @param int $value value of item parameter default
     * @param int $i order number in list to identify row
     * @param string $entity name of entity
     * @param boolean $canChange icon is active or disabled
     * @return string HTML code
     */
    public static function defaults ($value, $i, $entity, $canChange) {
        $states[JOOMDOC_STATE_UNDEFAULT] = array(J16 ? 'disabled.png' : 'administrator/images/disabled.png', JoomDOCHelper::getTask($entity, JOOMDOC_TASK_DEFAULT), 'JOOMDOC_DEFAULT', 'JOOMDOC_TO_DEFAULT');
        $states[JOOMDOC_STATE_DEFAULT] = array(J16 ? 'featured.png' : 'administrator/images/publish_g.png', JoomDOCHelper::getTask($entity, JOOMDOC_TASK_UNDEFAULT), 'JOOMDOC_UNDEFAULT', 'JOOMDOC_TO_UNDEFAULT');
        $state = JArrayHelper::getValue($states, $value, $states[JOOMDOC_STATE_DEFAULT]);
        $html = JHtml::_('image', (J16 ? 'admin/' : '') . $state[0], JText::_($state[2], true), null, true);
        if ($canChange)
            $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" title="' . JText::_($state[3], true) . '">' . $html . '</a>';
        return $html;
    }
}
?>