<?php
/**
 * OpenSEF component extension for Jomres
 *
 * This extension will give the OpenSEF style URLs to the Jomres component
 * Note that class must be named: sef_componentname
 *
 * Copyright (C) 2006 Artio s.r.o.
 *
 * Comments: for OpenSEF RC5 SP2
 **/
class sef_jomres
{

    /**
     * Creates the SEF advance URL out of the Mambo request
     * Input: $string, string, The request URL (index.php?option=com_example&Itemid=$Itemid)
     * Output: $sefstring, string, SEF advance URL ($var1/$var2/)
     **/
    function create($string, $path = null)
    {
        global $database, $sefConfig, $sefSite, $mosConfig_lang;

        // $string == "index.php?option=com_example&Itemid=$Itemid&var1=$var1&var2=$var2"
        // /option,com_jomres/task,viewproperty/Itemid,26/property_uid,1/lang,en/
        $sefstring = '';
        $title = array();

        $string = strtr($string, array('&amp;' => '&'));
        $url = parse_url($string);
        parse_str($url['query'], $params);
        $isDir = true;

        $siteID = is_null($sefSite->id) ? -1 : $sefSite->id;
        $alias = JosOpenSEFAlias::lookupOutgoing($siteID, $string);
        if ($alias) return '/'.$path.$alias->external;

        // Language.
        if (isset($params['lang'])) {
            $title[] = sefEncode($params['lang']);
            unset($params['lang']);
        }
        else {
            $title[] = getLangCode($mosConfig_lang);
        }

        // Resort name.
        if (isset($params['property_uid'])) {
            $title[] = sefEncode($this->getPropertyName($params['property_uid']));
            unset($params['property_uid']);
        }
        if (isset($params['selectedProperty'])) {
            $title[] = sefEncode($this->getPropertyName($params['selectedProperty']));
            unset($params['selectedProperty']);
        }

        // Resort name.
        if (isset($params['roomUid'])) {
            $title[] = 'room'.$params['roomUid'];
            unset($params['roomUid']);
        }

        // Popup.
        if (isset($params['popup']) && $params['popup'] == '1') {
            $title[] = 'popup';
            unset($params['popup']);
        }

        // Task.
        if (isset($params['task'])) {
            $title[] = sefEncode($params['task']);
            unset($params['task']);
            $isDir = false;
        }

        unset($params['option']);
        unset($params['Itemid']);
        unset($params['Itemid']);

        /*if (eregi("&amp;var2=",$string)) {
        $temp = split("&amp;var2=", $string);
        $temp = split("&", $temp[1]);
        $sefstring .= $temp[0]."/";
        }*/

        if (/*!isset($title) || count($title) == 0 ||*/ count($params) > 0) return $string;
        /*else {
        // Component name first.
        $menuTitle = getMenuTitle($params['option'], $params['task'], $params['Itemid']);
        array_unshift($title, $menuTitle);
        }*/
        $sefstring = join('/', $title).'/';
        if ($sefstring == '/') $sefstring = '';

        if (!$isDir && $sefConfig->encode_page_suffix != '' && $sefstring != '' && !eregi('index.php', $sefstring)) {
            $sefstring = substr($sefstring, 0, strlen($sefstring) - 1).$sefConfig->encode_page_suffix;
        }

        // Add unused params.
        /*if (count($params) > 0) {
        foreach ($params as $key => $param) {
        $addParams[] = $key.'='.$param;
        }
        $sefstring .= '?'.join('&', $addParams);
        }*/

        if (is_null($alias)) {
            $alias =& new JosOpenSEFAlias($database);
            $alias->site_id = $siteID;
            $alias->published = '1';
            $alias->valid = '1';
            $alias->external = '/'.$path.$sefstring;
            $alias->internal = $string;
            $alias->hits = 0;
            $alias->check();
            $alias->store();
        }

        return $sefstring;
    }

    /**
     * Returns the property's name when passed a property uid
     */
    function getPropertyName($property_uid)
    {
        // Gets the property name & returns the name as table data
        global $database;
        $database->setQuery("SELECT `property_name` FROM #__jomres_propertys WHERE `propertys_uid` = '$property_uid'");
        $rows = $database->loadObjectList();

        return (@count($rows) > 0) ? $rows[0]->property_name : false;
    }

}
?>
