<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

jimport('joomla.application.component.controllerform');

class JoomDOCControllerDocument extends JControllerForm {

    /**
     * Method override to check if you can edit an existing record.
     *
     * @param array $data An array of input data.
     * @param string $key The name of the key for the primary key.
     * @return	boolean
     */
    protected function allowEdit ($data = array (), $key = 'id') {
        $recordId = (int) isset($data[$key]) ? $data[$key] : 0;
        $ownerId = (int) isset($data['created_by']) ? $data['created_by'] : 0;
        if (empty($ownerId) && $recordId) {
            $record = $this->getModel()->getItem($recordId);
            if (empty($record))
                return false;
            $ownerId = $record->created_by;
        }
        if (JoomDOCAccessDocument::edit($recordId) || JoomDOCAccessDocument::editOwn($recordId, $ownerId, JFactory::getUser()->id))
            return true;
        return parent::allowEdit($data, $key);
    }

    /**
     * Add new document.
     *
     * @return void
     */
    public function add () {
        $mainframe = JFactory::getApplication();
        /* @var $mainframe JAdministrator */
        $mainframe->setUserState('path', ($path = JRequest::getString('path')));
        $model = $this->getModel();
        /* @var $model JoomDOCModelDocument */
        ($id = $model->searchIdByPath($path)) ? $this->setRedirect(JoomDOCRoute::editDocument($id)) : parent::add();
    }

    /**
     * Download file by relative path or document full alias.
     *
     * @return void
     */
    public function download () {
        JoomDOCFileSystem::download(false);
    }

    /**
     * Rename file/folder.
     */
    public function rename () {
        $mainframe =& JFactory::getApplication();
        /* @var $mainframe JApplication */
        $renamePath = JString::trim(JRequest::getString('renamePath'));
        $newName = JString::trim(JRequest::getString('newName'));
        $success = JoomDOCFileSystem::rename($renamePath, $newName);
        if ($success) {
            $mainframe->enqueueMessage(JText::_('JOOMDOC_RENAME_SUCCESS'));
        } else {
            $mainframe->enqueueMessage(JText::_('JOOMDOC_RENAME_FAILED'), 'error');
        }
        $mainframe->redirect(JoomDOCRoute::viewDocuments());
    }
}
?>