<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

jimport('joomla.application.component.controlleradmin');

class JoomDOCControllerDocuments extends JControllerAdmin {

    /**
     * Create new subfolder in current parent folder.
     *
     * @return void
     */
    public function newFolder () {
        if (JoomDOCAccessFileSystem::newFolder()) {
            $mainframe =& JFactory::getApplication();
            /* @var $mainframe JAdministrator */
            if (($msg = JoomDOCFileSystem::newFolder(JRequest::getString('path'), ($newFolder = JRequest::getString('newfolder'))))) {
                $mainframe->enqueueMessage(JText::sprintf($msg, $newFolder));
                JRequest::setVar('newfolder', '');
            }
        }
        $this->setRedirect(JoomDOCRoute::viewDocuments());
    }

    /**
     * Delete selected folders/files.
     *
     * @return void
     */
    public function deleteFile () {
        $count = 0;
        if (JoomDOCAccessFileSystem::deleteFile()) {
            $mainframe =& JFactory::getApplication();
            /* @var $mainframe JAdministrator */
            $count = JoomDOCFileSystem::delete(array_merge(JRequest::getVar('folders', array(), 'default', 'array'), JRequest::getVar('files', array(), 'default', 'array')));
        }
        $this->setRedirect(JoomDOCRoute::viewDocuments(), JText::sprintf('JOOMDOC_FILES_DELETED', $count));
    }

    /**
     * Upload file from request in current folder.
     *
     * @return void
     */
    public function uploadFile () {
        $count = 0;
        if (JoomDOCAccessFileSystem::uploadFile()) {
            $mainframe =& JFactory::getApplication();
            /* @var $mainframe JAdministrator */
            $count = JoomDOCFileSystem::upload(JRequest::getString('path'), 'upload', JRequest::getInt('iszip'));
            $mainframe->enqueueMessage($msg);
        }
        $this->setRedirect(JoomDOCRoute::viewDocuments(), JText::sprintf('JOOMDOC_FILES_UPLOADED'), $count);
    }

    /**
     * Proxy for getModel.
     *
     * @param string $name The name of the model.
     * @param string $prefix The prefix for the PHP class name.
     * @return JModel
     */
    public function getModel ($name = JOOMDOC_DOCUMENT, $prefix = JOOMDOC_MODEL_PREFIX, $config = array ('ignore_request' => true)) {
        return parent::getModel($name, $prefix, $config);
    }

    public function favorite () {
        $this->setFavorite(JOOMDOC_FAVORITE, 'JOOMDOC_DOCUMENTS_FAVORITE');
    }

    public function unfavorite () {
        $this->setFavorite(JOOMDOC_STANDARD, 'JOOMDOC_DOCUMENTS_UNFAVORITE');
    }

    /**
     * Set documents as favorite/unfavorite and redirect to documents list.
     *
     * @param int    $value use constants JOOMDOC_FAVORITE/JOOMDOC_STANDARD
     * @param string $msg   message on end, in message is by JText::sprintf puted num of affected rows
     * @return void
     */
    public function setFavorite ($value, $msg) {
        $model =& $this->getModel(JOOMDOC_DOCUMENTS);
        /* @var $model JoomDOCModelDocuments */
        $ids = JRequest::getVar('cid', array(), 'default', 'array');
        $affectedRows = $model->setFavorite($ids, $value);
        $this->setRedirect(JoomDOCRoute::viewDocuments(), JText::sprintf($msg, $affectedRows));
    }

    /**
     * Method to save the submitted ordering values for records.
     *
     * @since	1.6
     */
    public function saveorder () {
        // Check for request forgeries.
        JRequest::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

        // Get the input
        $order = JRequest::getVar('order', null, 'post', 'array');
        $pks = array_keys($order);
        $order = array_merge($order);
        
        // Sanitize the input
        JArrayHelper::toInteger($pks);
        JArrayHelper::toInteger($order);

        // Get the model
        $model = $this->getModel();

        // Save the ordering
        $return = $model->saveorder($pks, $order);

        if ($return === false) {
            // Reorder failed
            $message = JText::sprintf('JLIB_APPLICATION_ERROR_REORDER_FAILED', $model->getError());
            $this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false), $message, 'error');
            return false;
        } else {
            // Reorder succeeded.
            $this->setMessage(JText::_('JLIB_APPLICATION_SUCCESS_ORDERING_SAVED'));
            $this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
            return true;
        }
    }
}
?>