<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCHelper {

    /**
     * Get current logged user allowed actions.
     *
     * @return JObject
     */
    public static function getActions ($section) {
        $user =& JFactory::getUser();
        /* @var $user JUser */
        $result = new JObject();
        foreach (get_defined_constants() as $key => $value)
            if (JString::strpos($key, 'JOOMDOC_CORE_') === 0)
                $result->set($value, $user->authorise($value, JoomDOCHelper::getAction($section)));
        return $result;
    }

    /**
     * Get task parameter format.
     *
     * @param string $entity entity name
     * @param string $task task name
     * @return string
     */
    public static function getTask ($entity, $task) {
        return $entity . '.' . $task;
    }

    /**
     * Get access action format.
     *
     * @param string $section access section name
     * @return string
     */
    public static function getAction ($section) {
        return JOOMDOC_OPTION . '.' . $section;
    }

    /**
     * Set component submenu.
     *
     * @param string $view opened view page
     * @return void
     */
    public function setSubmenu ($view) {
        JSubMenuHelper::addEntry(JText::_('JOOMDOC_CONTROL_PANEL'), JoomDOCRoute::viewJoomDOC(), $view == JOOMDOC_JOOMDOC);
        JSubMenuHelper::addEntry(JText::_('JOOMDOC_DOCUMENTS'), JoomDOCRoute::viewDocuments(), $view == JOOMDOC_DOCUMENTS);
        JSubMenuHelper::addEntry(JText::_('JOOMDOC_UPGRADE'), JoomDOCRoute::viewUpgrade(), $view == JOOMDOC_UPGRADE);
    }

    /**
     * Display number in human readable format without wrap.
     *
     * @param int $number
     * @return string
     */
    public function number ($number) {
        return JoomDOCHelper::nowrap(number_format((int) $number, 0, '', JText::_('JOOMDOC_THOUSANDS_SEPARATOR')));
    }

    /**
     * Display date uploade in human readable format without wrap.
     *
     * @param int $date unix timestamp
     * @return string
     */
    public function uploaded ($date, $timestamp = true) {
        if (!$timestamp && $date == '0000-00-00 00:00:00')
            return '';
        return JoomDOCHelper::nowrap(JHtml::date($timestamp ? date('Y-m-d H:i:s', $date) : $date, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG)));
    }

    /**
     * Make text nowrap.
     *
     * @param string $text
     * @return string
     */
    public function nowrap ($text) {
        return '<span class="nowrap">' . $text . '</span>';
    }

    /**
     * Set CSS class for file mimetype icon.
     *
     * @param string $mimetype file mimetype
     * @return string function return numm if icon is no available
     */
    public function setFileIcon ($mimetype) {
        static $cache;
        if (is_null($cache))
            $cache = array();
        $class = str_replace('application/', '', $mimetype);
        if (isset($cache[$class]))
            return $class;
        $filename = sprintf('mtype-%s.png', $class);
        if (JFile::exists((JOOMDOC_PATH_IMAGES . DS . $filename))) {
            JFactory::getDocument()->addStyleDeclaration(sprintf('.%s{background-image: url("%s%s");}', $class, JOOMDOC_IMAGES, $filename));
            $cache[$class] = true;
            return $class;
        }
        return null;
    }

    /**
     * Crop text into set length. Before strip HTML tags. After croping add on end ender string (e.q. ...).
     * If text is shorter then legth return text without ender string. Crop end with number or letter. No by chars like: , . - _ etc.
     *
     * @param string $text   string to crop
     * @param int    $length crop length
     * @param string $ender  ender string, default ...
     * @return string
     */
    function crop ($text, $length, $ender = '...') {
        $text = strip_tags($text);
        $text = JString::trim($text);
        $strlen = JString::strlen($text);
        if ($strlen <= $length)
            return $text;
        $lastSpace = JString::strpos($text, ' ', $length);
        if ($lastSpace === false) {
            $crop = JString::substr($text, 0, $length);
        } else {
            $crop = JString::substr($text, 0, $lastSpace);
        }
        static $noLetters;
        if (is_null($noLetters)) {
            $noLetters = array('.', ',', '-', '_', '!', '?', '(', ')', '%', '', '@', '#', '$', '^', '&', '*', '+', '=', '"', '\'', '/', '\\', '§', '<', '>', ':', '{', '}', '[', ']');
        }
        do {
            $strlen = JString::strlen($crop);
            $lastChar = JString::substr($crop, ($strlen - 1), 1);
            if (in_array($lastChar, $noLetters)) {
                $crop = JString::substr($crop, 0, ($strlen - 1));
            } else {
                break;
            }
        } while (true);
        $crop = JString::trim($crop);
        if ($crop)
            $crop .= $ender;
        return $crop;
    }

    /**
     * Convert array to javascript array string and put into html head.
     *
     * @param string $name name of javascript array
     * @param array $items array items, are inserted as string safed with addslashes method
     * @return void
     */
    function jsArray ($name, $items) {
        $js = 'var ' . $name . ' = new Array(';
        if (count($items)) {
            $items = array_map('addslashes', $items);
            $js .= '"' . implode('", "', $items) . '"';
        }
        $js .= ');' . PHP_EOL;
        $document =& JFactory::getDocument();
        /* @var $document JDocumentHTML */
        $document->addScriptDeclaration($js);
    }

    /**
     * Get meta description text format. Clean text and crop to 150 characters.
     *
     * @param string $text
     * @return string
     */
    function getMetaDescriptions ($text) {
        $text = JFilterOutput::cleanText($text);
        $text = JString::trim($text);
        if (JString::strlen($text) <= 150) {
            return $text;
        }
        $text = JString::substr($text, 0, 150);
        $lastFullStop = JString::strrpos($text, '.');
        if ($lastFullStop !== false) {
            $text = JString::substr($text, 0, $lastFullStop + 1);
        }
        $text = JString::trim($text);
        return $text;
    }

    /**
     * Add after title sitename to complet page title.
     *
     * @param string $title
     * @return string
     */
    function getCompletTitle ($title) {
        $mainframe =& JFactory::getApplication();
        /* @var $mainframe JApplication */
        $candidates[] = JString::trim($title);
        $candidates[] = JString::trim($mainframe->getCfg('sitename'));
        JoomDOCHelper::cleanArray($candidates);
        $completSiteName = implode(' - ', $candidates);
        return $completSiteName;
    }

    /**
     * Get first no empty item from array.
     *
     * @param array $array
     * @return mixed
     */
    function getFirstNoEmpty (&$array) {
        foreach ($array as $item) {
            if (!empty($item)) {
                return $item;
            }
        }
        return '';
    }

    /**
     * Cleanup array. Unset or empty items.
     * 
     * @param array $array
     */
    function cleanArray (&$array) {
        foreach ($array as $key => $item) {
            if (empty($item)) {
                unset($array[$key]);
            }
        }
    }
}
?>