<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

jimport('joomla.application.component.modellist');

class JoomDOCModelList extends JModelList {
    /**
     * Filter items for list.
     *
     * @var array
     */
    protected $filter;

    /**
     * Auto-populate the model state.
     *
     * @return	void
     */

    public function __construct ($config) {
        $this->option = JOOMDOC;
        parent::__construct($config);
        if (!isset($this->state)) {
            $this->populateState();
            $this->state = $this->getState();
        }
    }

    protected function populateState ($ordering = null, $direction = null) {
        if (isset($this->filter)) {
            $mainframe =& JFactory::getApplication();
            /* @var $mainframe JApplication */

            foreach ($this->filter as $name => $type) {
                $value = $this->cleanData($this->getUserStateFromRequest($this->getSessionName($name), JoomDOCView::getFieldName($name), $this->getDefaultValue($type), $type), $type);
                $this->setState(JoomDOCView::getStateName($name), $value);
            }

            if ($mainframe->isSite())
                $this->setState(JoomDOCView::getStateName(JOOMDOC_FILTER_ACCESS), true);

            parent::populateState(reset(array_keys($this->filter)), 'asc');
        }
    }

    /**
     * Get property session key name.
     *
     * @param string $name property name
     * @return string
     */
    public function getSessionName ($name) {
        return sprintf('%s.filter.%s', $this->context, $name);
    }

    /**
     * Method to get a store id based on model configuration state.
     *
     * @param string $id a prefix for the store id.
     * @return string a store id.
     */
    protected function getStoreId ($id = '') {
        foreach ($this->filter as $name => $type)
            $id .= sprintf(':%s', JoomDOCView::getStateName($name));
        return parent::getStoreId($id);
    }

    /**
     * Get property value from model state.
     *
     * @param string $name property name
     * @param mixed $default property default value if state is no available
     * @return mixed property from model state or default value
     */
    public function getState ($name = null, $default = null) {
        return parent::getState(JoomDOCView::getStateName($name, $default));
    }

    /**
     * Get default value for data type.
     *
     * @param string $dataType data type string name int|array|string
     * @return mixed default value
     */
    public function getDefaultValue ($dataType) {
        switch ($dataType) {
            case JOOMDOC_INT:
                return 0;
            case JOOMDOC_ARRAY:
                return array();
            case JOOMDOC_STRING:
                return '';
            default:
                return null;
        }
    }

    /**
     * Clean data by their data type.
     *
     * @param mixed $value data value
     * @param string $dataType data type
     * @return mixed
     */
    public function cleanData ($value, $dataType) {
        switch ($dataType) {
            case JOOMDOC_INT:
                return (int) $value;
            case JOOMDOC_STRING:
                return JString::trim($value);
            default:
                return $value;
        }
    }
    /**
     * Copy row of database without primary key. After copy is row checkin.
     *
     * @param string $table  table name
     * @param string $pkey   primary key
     * @param string $pvalue primary key value
     * @return boolean
     */
    public function copyRow ($table, $pkey, $pvalue) {
        $db = JFactory::getDbo();
        /* @var $db JDatabaseMySQL */
        $fields = $db->getTableFields($table);
        $fields = reset($fields);
        unset($fields[$pkey]);
        $fields = array_keys($fields);
        $sfields = implode('`,`', $fields);
        $query = 'INSERT INTO `%s` (`%s`) (SELECT `%s` FROM `%s` WHERE `%s` =  %d)';
        $query = sprintf($query, $table, $sfields, $sfields, $table, $pkey, $pvalue);
        $db->setQuery($query);
        $db->query();
        if (in_array('checked_out', $fields) && in_array('checked_out_time', $fields)) {
            $query = 'UPDATE `%s` SET `checked_out` = 0, `checked_out_time` = "0000-00-00 00:00:00" WHERE `id` = %d';
            $query = sprintf($query, $table, $db->insertid());
            $db->setQuery($query);
            $db->query();
        }
    }
}
?>












