<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

jimport('joomla.methods');

class JoomDOCRoute extends JRoute {

    /**
     * Get URL to open component.
     *
     * @return string
     */
    public function viewJoomDOC () {
        return 'index.php?option=' . JOOMDOC_OPTION;
    }

    /**
     * Get URL to open page with categories list.
     *
     * @return string
     */
    public function viewCategories () {
        return 'index.php?option=com_categories&extension=' . JOOMDOC_OPTION;
    }

    /**
     * Get URL to open page with documents.
     *
     * @return string
     */
    public function viewDocuments ($path = null, $alias = null) {
        $itemID = JoomDOCMenu::getMenuItemID($path);
        return 'index.php?option=' . JOOMDOC_OPTION . '&view=' . JOOMDOC_DOCUMENTS . ($path ? '&path=' . JoomDOCString::urlencode($path) : '') . ($itemID ? '&Itemid=' . $itemID : '');
    }

    /**
     * Get URL to open edit document page.
     *
     * @param int $id document ID
     * @return string
     */
    public function editDocument ($id) {
        return 'index.php?option=' . JOOMDOC_OPTION . '&task=' . JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_EDIT) . '&id=' . $id;
    }

    /**
     * Get URL to add new document.
     *
     * @param string $id file path
     */
    public function addDocument ($path) {
        return 'index.php?option=' . JOOMDOC_OPTION . '&task=' . JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_ADD) . '&path=' . JoomDOCString::urlencode($path);
    }

    /**
     * Get URL to save document.
     *
     * @param int $id document ID
     * @return string
     */
    public function saveDocument ($id) {
        return 'index.php?option=' . JOOMDOC_OPTION . '&layout=edit&id=' . $id;
    }

    /**
     * Open documents list in modal window.
     *
     * @param int $id
     * @return string
     */
    public function modalDocuments ($folder = null) {
        return 'index.php?option=' . JOOMDOC_OPTION . '&view=' . JOOMDOC_DOCUMENTS . '&layout=modal&tmpl=component' . ($folder ? ('&path=' . JoomDOCString::urlencode($folder)) : '');
    }

    /**
     * Get URL to download file.
     *
     * @param string $path
     * @return string
     */
    public function download ($path, $alias = null, $version = null) {
        if ($alias) {
            $path = $alias;
        }
        return 'index.php?option=' . JOOMDOC_OPTION . '&task=' . JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_DOWNLOAD) . '&path=' . JoomDOCString::urlencode($path) . ($version ? '&version=' . $version : '');
    }

    /**
     * Get URL to view upgrade page.
     *
     * @return string
     */
    public function viewUpgrade () {
        return 'index.php?option=' . JOOMDOC_OPTION . '&view=' . JOOMDOC_UPGRADE;
    }

    /**
     * Get URL to view file detail.
     *
     * @param string $path
     * @return string
     */
    public function viewFileInfo ($path) {
        return 'index.php?option=' . JOOMDOC_OPTION . '&view=' . JOOMDOC_FILE . '&path=' . JoomDOCString::urlencode($path);
    }
}
?>