<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocuments */

	
$config = JoomDOCConfig::getInstance();

$listOrder = $this->escape($this->state->get(JOOMDOC_FILTER_ORDERING));
$listDirn = $this->escape($this->state->get(JOOMDOC_FILTER_DIRECTION));

$ordering = $listOrder == JOOMDOC_ORDER_ORDERING;
$canOrder = JoomDOCAccessDocument::editState();

$user = &JFactory::getUser();
/* @var $user JUser */

// favorite states
$states[0]['task'] = 'favorite';
$states[1]['task'] = 'unfavorite';

$states[0]['text'] = 'JOOMDOC_SET_FAVORITE';
$states[1]['text'] = 'JOOMDOC_SET_UNFAVORITE';

$states[0]['icon'] = JURI::base(true).'/images/publish_x.png';
$states[1]['icon'] = JURI::base(true).'/images/tick.png';

$states[0]['active_title'] = $states[1]['inactive_title'] = 'JOOMDOC_STANDARD';
$states[1]['active_title'] = $states[0]['inactive_title'] = 'JOOMDOC_FAVORITE';

$states[0]['active_class'] = $states[0]['inactive_class'] = 'notdefault';
$states[1]['active_class'] = $states[1]['inactive_class'] = 'default';

$states[0]['tip'] = $states[1]['tip'] = true;

$files = $folders = array();

?>
<div id="joomdoc">

	<div id="pathway">
<?php
    $i = 0;
    foreach (JoomDOCFileSystem::getPathBreadCrumbs($this->root->getAbsolutePath()) as $path => $name) {
        $i++;
?>
			<span class="item">
			    <?php echo ($i == 1) ? '' : JText::_('JOOMDOC_PATHWAY_SEPARATOR'); ?>
			    <a href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($path)); ?>" class="hasTip" title="<?php echo $this->getTooltip($path, 'JOOMDOC_DOCUMENTS_OPEN_FOLDER'); ?>"><?php echo $name; ?></a>
			</span>		
<?php	
	}	
    if (JoomDOCFileSystem::isSubFolder(($parentPath = JoomDOCFileSystem::getParentPath($this->root->getAbsolutePath())), $config->docroot)) { 
?>	
	<a class="back" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($parentPath)); ?>" title=""><?php echo JText::_('JOOMDOC_BACK'); ?></a>
<?php } ?>		
	</div>

	<form action="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($this->root->getAbsolutePath())); ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
		<fieldset id="filter-bar">
			<div>
				<label for="filter" class="hasTip filter-search-lbl" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_FILTER'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_FILTER'); ?>:</label>
				<input type="text" name="filter" id="filter" value="<?php echo $this->escape($this->filter); ?>" />
				<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button type="button" onclick="var f=this.form;f.filter.value='';f.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
				
				<?php 
					if (JoomDOCAccessFileSystem::uploadFile()) { 
				?>
						<label for="upload" class="hasTip filter-search-lbl" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_UPLOADFILE'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_UPLOADFILE'); ?>:</label>			
						<input type="file" name="upload" id="upload" />
						<input type="checkbox" name="iszip" id="iszip" value="1" />
						<label class="hasTip filter-search-lbl" for="iszip" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_UNPACK_ZIP'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_UNPACK_ZIP'); ?></label>
						<button type="submit" class="btn" onclick="return JoomDOC.upload(this, '<?php echo addslashes(JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_UPLOADFILE)); ?>', '<?php echo JText::_('JOOMDOC_UPLOAD_EMPTY', true); ?>', '<?php echo JText::_('JOOMDOC_UPLOAD_OVERWRITE', true); ?>', '<?php echo JText::_('JOOMDOC_UPLOAD_DIR_EXISTS', true); ?>')"><?php echo JText::_('JOOMDOC_UPLOAD'); ?></button>
				<?php 
					} 
				 	if (JoomDOCAccessFileSystem::newFolder()) { 
				?>
						<label class="hasTip filter-search-lbl" for="newfolder" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_NEW_FOLDER'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_NEW_FOLDER'); ?>:</label>
						<input type="text" name="newfolder" id="newfolder" value="<?php echo $this->escape(JRequest::getString('newfolder')); ?>" />
						<button type="submit" class="btn" onclick="return JoomDOC.mkdir(this, '<?php echo addslashes(JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_NEWFOLDER)); ?>', '<?php echo JText::_('JOOMDOC_MKDIR_EMPTY', true); ?>', '<?php echo JText::_('JOOMDOC_MKDIR_FILE_EXISTS', true); ?>', '<?php echo JText::_('JOOMDOC_MKDIR_DIR_EXISTS', true); ?>')"><?php echo JText::_('JOOMDOC_CREATE'); ?></button>
				<?php } ?>
			</div>
		</fieldset>
		<table class="adminlist" cellspacing="1">
			<thead>
				<tr>
					<th width="1%"><input type="checkbox" name="checkall-toggle" value="" onclick="checkAll(this)" /></th>
					<th><?php echo JHtml::_('grid.sort',  'JOOMDOC_DOCUMENTS_ITEM', JOOMDOC_ORDER_PATH, $listDirn, $listOrder); ?></th>
					<th width="1%">&nbsp;</th>
															<th width="1%"><?php echo JHtml::_('grid.sort',  'JOOMDOC_UPLOADED', JOOMDOC_ORDER_UPLOAD, $listDirn, $listOrder); ?></th>
					<th width="1%"><?php echo JText::_('JOOMDOC_SIZE'); ?></th>
					<th width="20%"><?php echo JHtml::_('grid.sort',  'JOOMDOC_DOCUMENT', JOOMDOC_ORDER_TITLE, $listDirn, $listOrder); ?></th>
					<th width="1%"><?php echo JText::_('JOOMDOC_PUBLISHED'); ?></th>
					<th width="1%"><?php echo JText::_('JOOMDOC_FAVORITE'); ?></th>
					<th width="10%">
						<?php 
							echo JHtml::_('grid.sort',  'JGRID_HEADING_ORDERING', JOOMDOC_ORDER_ORDERING, $listDirn, $listOrder);
							$fake = array();
							$count = $this->pagination->total = $this->root->getItemsCount();
							for ($i = 0; $i < $count; $i++)
								$fake[] = $i;
						 	if ($canOrder && $ordering)
							 	echo JHtml::_('grid.order', $fake, 'filesave.png', JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_SAVEORDER));
						 ?>
					</th>
					<th width="1%"><?php echo JText::_('JOOMDOC_ACCESS'); ?></th>
					<th width="1%"><?php echo JHtml::_('grid.sort',  'JOOMDOC_HITS', JOOMDOC_ORDER_HITS, $listDirn, $listOrder); ?></th>
				</tr>
			</thead>
			<tbody id="tdoc">
				<?php 
					$this->root->initIteration();
	
					$i = 0;
					
					while ($this->root->hasNext()){
						
						$prevItem = $this->root->getNext(JOOMDOC_ORDER_PREV);
						$nextItem = $this->root->getNext(JOOMDOC_ORDER_NEXT);
						$item = $this->root->getNext();
						
						if (JoomDOCFileSystem::isFile($item)) {
							$files[] = $item->getFileName();
						} elseif (JoomDOCFileSystem::isFolder($item)) {
							$folders[] = $item->getFileName();
						}
						
						$documentId = 0;
						
						$isChecked = $item->document && $item->document->checked_out != 0 && $item->document->checked_out != $user->id;
						$isLocked = false;
										?>
	
						<tr class="row<?php echo $i % 2; ?>">
							<td class="center">
				<?php
								if ($item->document) {
						
									$canEdit = JoomDOCAccessDocument::edit($item->document->id) && JoomDOCAccessDocument::edit();
									$canCheckin = JoomDOCAccessDocument::manage($item->document->checked_out, $user->id) && JoomDOCAccess::manage();
									$canEditOwn = JoomDOCAccessDocument::editOwn($item->document->id, $item->document->created_by, $user->id) && JoomDOCAccessDocument::editOwn();
									$canChange = JoomDOCAccessDocument::editState($item->document->id, $item->document->checked_out, $user->id) && JoomDOCAccessDocument::editState();
						
									if ($isChecked) {
										echo JHtml::_('jgrid.checkedout', $i, $item->document->editor, $item->document->checked_out_time, 'documents.', $canCheckin);
									} else
										$documentId = $item->document->id;
								}
				?>
	
								<input type="checkbox" name="<?php echo JoomDOCFileSystem::isFolder($item) ? 'folders' : 'files'; ?>[]" id="cbb<?php echo $i; ?>" value="<?php echo $this->escape($item->getAbsolutePath()); ?>" class="blind" />
								
								<?php if (!$isChecked && !$isLocked) { ?>
									<input type="checkbox" name="cid[]" id="cb<?php echo $i; ?>" value="<?php echo $documentId; ?>" onclick="isChecked(this.checked);JoomDOC.check(this,<?php echo $i; ?>)" />
								<?php } ?>
							</td>
							<td class="filepath">
								<?php if (JoomDOCFileSystem::isFolder($item)) { ?>
						
									<a class="hasTip folder" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($item->getAbsolutePath())); ?>" title="<?php echo $this->getTooltip($item->getAbsolutePath(), 'JOOMDOC_DOCUMENTS_OPEN_FOLDER'); ?>"><?php echo $item->getFileName(); ?></a>
						
								<?php } else { ?>
					
									<a href="<?php echo JRoute::_(JoomDOCRoute::download($item->getRelativePath())); ?>" class="hasTip file" title="<?php echo $this->getTooltip($item->getAbsolutePath(), 'JOOMDOC_DOWNLOAD_FILE'); ?>"><?php echo $item->getFileName(); ?></a>
								
								<?php } ?>
									
								<div class="rename blind">
									<input type="text" name="rename" value="<?php echo $this->escape($item->getFileName()); ?>" />
									<button onclick="return JoomDOC.rename(this, '<?php echo addslashes(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_RENAME)); ?>', '<?php echo addslashes($item->getFileName()); ?>', '<?php echo addslashes($item->getRelativePath()); ?>', '<?php echo JText::_('JOOMDOC_RENAME_SAME_NAME', true); ?>', '<?php echo JText::_('JOOMDOC_RENAME_EMPTY_NAME', true); ?>', '<?php echo JText::_('JOOMDOC_RENAME_FILE_EXISTS', true); ?>', '<?php echo JText::_('JOOMDOC_RENAME_DIR_EXISTS', true); ?>')"><?php echo JText::_('JOOMDOC_RENAME_SAVE'); ?></button>
									<button onclick="return JoomDOC.closeRename(this, '<?php echo addslashes($item->getFileName()); ?>')"><?php echo JText::_('JOOMDOC_RENAME_CLOSE'); ?></button>
								</div>
							</td>
							<td class="rename">
								<a href="javascript:void(0)" class="rename" id="openRename<?php echo $i; ?>" onclick="JoomDOC.openRename(<?php echo $i; ?>)" title="<?php echo JText::_('JOOMDOC_RENAME', true); ?>"></a>
							</td>
							
														
														
							<td><?php echo isset($item->upload) ? JoomDOCHelper::uploaded($item->upload, false) : ''; ?></td>
							<td><?php echo JoomDOCFileSystem::isFolder($item) ? '-' : $item->getFileSize(); ?></td>
				
							<?php if ($item->document) { ?>
				
							<td>
					
								<?php 									
									if (($canEdit || $canEditOwn) && !$isChecked) { 
								?>
										<a href="<?php echo JRoute::_(JoomDOCRoute::editDocument($item->document->id)); ?>" title="<?php echo $this->getTooltip($item->document->title, 'JOOMDOC_EDIT_DOCUMENT'); ?>" class="hasTip"><?php echo $this->escape($item->document->title); ?></a>
								<?php
									} else { 
										echo $this->escape($item->document->title);
									}
								?>
					
							</td>
					
							<td class="center" align="center">
								<?php 
									echo JHtml::_('jgrid.published', $item->document->state, $i, 'documents.', $canChange, 'cb', $item->document->publish_up, $item->document->publish_down); 
								?>
							</td>
							
							<td class="center" align="center">
								<?php 
									echo JHtml::_('jgrid.state', $states, $item->document->favorite, $i, 'documents.', $canChange, true); 
								?>
							</td>
					
							<td class="order">
								<?php 
									if ($canChange) {
							 			if ($ordering) { 
								 			if ($listDirn == 'asc') { 
								?>
					
												<span><?php echo $this->pagination->orderUpIcon($i, ($item->document->parent_path == @$prevItem->document->parent_path), JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_ORDERUP), 'JLIB_HTML_MOVE_UP', $ordering); ?></span>
									
												<span><?php echo $this->pagination->orderDownIcon($i, $this->pagination->total, ($item->document->parent_path == @$nextItem->document->parent_path), JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_ORDERDOWN), 'JLIB_HTML_MOVE_DOWN', $ordering); ?></span>
								
								<?php 
											} elseif ($listDirn == 'desc') {
								?>
					
												<span><?php echo $this->pagination->orderUpIcon($i, ($item->document->parent_path == @$prevItem->document->parent_path), JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_ORDERDOWN), 'JLIB_HTML_MOVE_UP', $ordering); ?></span>
									
												<span><?php echo $this->pagination->orderDownIcon($i, $this->pagination->total, ($item->document->parent_path == @$nextItem->document->parent_path), JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_ORDERUP), 'JLIB_HTML_MOVE_DOWN', $ordering); ?></span>
								
								<?php 
											} 
										} 
								?>
										<input type="text" name="order[<?php echo $item->document->id; ?>]" size="5" value="<?php echo $item->document->ordering;?>" <?php if (!$ordering) { ?>disabled="disabled"<?php } ?> class="text-area-order" />
								<?php 
									} else 
										echo $item->document->ordering; 
								?>
							</td>
					
							<td class="center"><?php echo $this->escape($item->document->access_title); ?></td>
					
						<?php } else { ?>
							<td colspan="5">
								<?php if (JoomDOCAccessDocument::create()) { ?>
									<a href="<?php echo JRoute::_(JoomDOCRoute::addDocument($item->getRelativePath())); ?>" class="hasTip addDocument" title="<?php echo $this->getTooltip('JOOMDOC_ADD_DOCUMENT'); ?>"></a>
								<?php } ?>
							</td>
						<?php } ?>
						<td class="center"><?php echo JoomDOCHelper::number($item->hits); ?></td>
					</tr>			
				<?php 
					$i ++;
					}
					if (empty($files) && empty($folders)) {
				?>
						<tr><td colspan="20"><?php echo JText::_('JOOMDOC_EMPTY_FOLDER'); ?></td></tr>
				<?php } ?>
			</tbody>
		</table>		
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<input type="hidden" name="renamePath" value="" />
		<input type="hidden" name="newName" value="" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
<?php 
	JoomDOCHelper::jsArray('joomdocFiles', $files);
	JoomDOCHelper::jsArray('joomdocFolders', $folders);
?>