<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCViewFile extends JoomDOCView {
    /**
     * List of file versions
     *
     * @var array
     */
    var $data;
    /**
     * Browse table filter
     *
     * @var stdClass
     */
    var $filter;

    /**
     * Display browse table of file versions with extended filter.
     *
     * @param string $tpl used template
     */
    public function display ($tpl = null) {
        $mainframe = JFactory::getApplication();
        /* @var $mainframe JAdministrator */
        $model =& $this->getModel();
        /* @var $model JoomDOCModelFile */
        $this->filter = new stdClass();
        $this->filter->path = JRequest::getString('path');
        $sprefix = 'joomdoc_file_version_list_' . $this->filter->path . '_';
        $this->filter->offset = $mainframe->getUserStateFromRequest($sprefix . 'offset', 'limitstart', 0, 'int');
        $this->filter->limit = $mainframe->getUserStateFromRequest($sprefix . 'limit', 'limit', 10, 'int');
        $this->filter->listOrder = $mainframe->getUserStateFromRequest($sprefix . 'listOrder', 'filter_order', 'version', 'string');
        $this->filter->listDirn = $mainframe->getUserStateFromRequest($sprefix . 'listDirn', 'filter_order_Dir', 'asc', 'string');
        $this->filter->uploader = $mainframe->getUserStateFromRequest($sprefix . 'uploader', 'uploader', '', 'string');
        $this->data = $model->getData($this->filter);
        $this->addToolbar();
        parent::display($tpl);
    }

    /**
     * Add page main toolbar.
     *
     * @return void
     */
    protected function addToolbar () {
        JToolBarHelper::title(JText::_('JOOMDOC_FILE'), 'file');
        JToolBarHelper::back('Back', JRoute::_(JoomDOCRoute::viewDocuments()));
    }
}
?>