<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

$language =& JFactory::getLanguage();
/* @var $language JLanguage */
$language->load('com_joomdoc', JPATH_ADMINISTRATOR);

/**
 * Build SEF route.
 *
 * @param array $query URL query string without Joomla internal params as option, Itemid etc.
 * @return array SEF URL segments
 */
function JoomDOCBuildRoute (&$query) {
    $segments = array();

    // file/folder relative path or document full alias
    if (isset($query['path'])) {
        $segments[] = $query['path'];
        unset($query['path']);
    }
    // task action type
    if (isset($query['task'])) {
        switch ($query['task']) {
            case 'document.download':
            	/*
                if (isset($query['version'])) {
                    $version = (int) $query['version'];
                    if ($version) {
                        $segments[] = JText::sprintf('JOOMDOC_VERSION_NUMBER', $version);
                    }
                    unset($query['version']);
                }
                */
                $segments[] = JText::_('JOOMDOC_DOWNLOAD');
                break;
        }
        unset($query['task']);
    }
    // page view type
    if (isset($query['view'])) {
        switch ($query['view']) {
            case 'documents':
                $segments[] = JText::_('JOOMDOC_DETAIL');
                break;
        }
        unset($query['view']);
    }

    return $segments;
}

/**
 * Parse SEF URL to real URL.
 *
 * @param array $segments SEF URL segments without menu item segment
 * @return array real URL query string without Joomla internal params as option, Itemid etc.
 */
function JoomDOCParseRoute ($segments) {

    if (count($segments)) {
        // file/folder relative path or document full alias
        $last = count($segments) - 1;
        switch ($segments[$last]) {
            case JText::_('JOOMDOC_DOWNLOAD'):
                // download file task action
                $vars['task'] = 'document.download';
                break;
            case JText::_('JOOMDOC_DETAIL'):
                // view document/folder/file page view
                $vars['view'] = 'documents';
                break;
        }
        unset($segments[$last]);
        $segmentsCount = count($segments);
        if (isset($_SERVER['REQUEST_URI'])) {
            $parts = explode('/', $_SERVER['REQUEST_URI']);
            // cleanup array
            foreach ($parts as $key => $part) {
                if (!JString::trim($part)) {
                    unset($parts[$key]);
                }
            }
            // reindexing
            $parts = array_merge($parts);
            $requestURICount = count($parts);
            $offset = $requestURICount - $segmentsCount - 1;
            $length = $segmentsCount;
            $vars['path'] = array_slice($parts, $offset, $length);
            $vars['path'] = implode('/', $vars['path']);
        } else {
            $vars['path'] = implode('/', $segments);
        }
    } else {
        $vars['view'] = 'documents';
        $vars['path'] = '';
    }
    return $vars;
}
?>