<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocuments */

$config = JoomDOCConfig::getInstance();

?>
<div id="documents">

	<?php if (!$this->inRoot && $this->root->getRelativePath()) { ?>

			<a class="back" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments(JoomDOCFileSystem::getParentPath($this->root->getRelativePath(), $this->root->document ? $this->root->document->full_alias : null))); ?>" title=""><?php echo JText::_('JOOMDOC_BACK'); ?></a>

	<?php } ?>

	<?php if ($config->docroot == $this->root->getAbsolutePath() && $config->defaultTitle) { ?>
		
		<h1><?php echo $config->defaultTitle; ?></h1>
	
	<?php } else { ?>
	
		<h1><?php echo $this->root->document ? $this->root->document->title : $this->root->getRelativePath(); ?></h1>
	
	<?php } ?>
	
	<?php if ($config->docroot == $this->root->getAbsolutePath() && $config->defaultDescription) { ?>
	
		<p><?php echo $config->defaultDescription; ?></p>
	
	<?php } elseif ($this->root->document && ($description = JString::trim($this->root->document->description))) { ?>
	
		<p><?php echo $description; ?></p>
			
	<?php }
	
	$this->root->initIteration();

	$filesWithouDoc = true;
	if ($this->root->document) {
		$params = new JRegistry($this->root->document->params);
		$filesWithouDoc = (int) $params->getValue('files_without_doc', 1);
	}
	
	$class = null;
	
	if (! $this->root->hasNext()) {
	?>
		<p class="empty"><?php echo JText::_('JOOMDOC_EMPTY_FOLDER'); ?></p>
	<?php
	}
	
	
	while ($this->root->hasNext()) {
		
		$item = $this->root->getNext();
		
		// no subfolders
		if (JoomDOCFileSystem::isFolder($item) && ! $config->showSubfolders)
			continue;

		// no display files without doc	
		if (! $item->document && (! $filesWithouDoc || ! $config->filesWithoutDoc)){
			continue;
		}
		
		// document is unpublish	
		if ($item->document && $item->document->published == 0)
			continue;
			
		if ($config->showFileicon)
			$class = JoomDOCFileSystem::isFile($item) ? JoomDOCHelper::setFileIcon($item->getMimeType()) : 'folder';
			
		$alias = $item->document ? $item->document->full_alias : null;
		$viewDocuments = JRoute::_(JoomDOCRoute::viewDocuments($item->getRelativePath(), $alias));
		
		// document has favorite mark
		$isFavorite = $item->document && $item->document->favorite == 1;
		$displayFavorite = $isFavorite && $config->displayFavorite;
?>
		<div class="document<?php if ($isFavorite) { ?> favorite<?php } ?>">
		
			<h2 <?php if ($class) { ?>class="icon <?php echo $class; ?>"<?php } ?>><a href="<?php echo $viewDocuments; ?>" title=""><?php echo $item->document ? $item->document->title : $item->getFileName(); ?></a></h2>
			
			<?php 
				if (($item->document &&  ($config->showCreated || $config->showModified)) || (! JoomDOCFileSystem::isFolder($item) && ($config->showFilesize || $config->showHits)) || $displayFavorite) { 
			?>
					<div class="info">
						<?php 
							if ($displayFavorite) {
						?>
								<span class="favorite"><?php echo JText::_('JOOMDOC_FAVORITE'); ?></span>
						<?php	
							}
						?>
					
						<?php 
							if ($config->showFilesize && ! JoomDOCFileSystem::isFolder($item)) { 
						?>
								<span class="filesize"><?php echo JText::sprintf('JOOMDOC_FILESIZE', JoomDOCFileSystem::getFileSize($item->getAbsolutePath())); ?></span>
						<?php 
							} 
							if ($item->document) {
								if ($config->showCreated) {
						?>
									<span class="created"><?php echo JText::sprintf('JOOMDOC_CREATED', JHtml::date($item->document->created, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
						<?php	
								}
								if ($config->showModified && $item->document->modified != '0000-00-00 00:00:00') {
						?>
									<span class="modified"><?php echo JText::sprintf('JOOMDOC_MODIFIED', JHtml::date($item->document->modified, JText::_('JOOMDOC_UPLOADED_DATE_' . JTAG))); ?></span>
						<?php 
								}
							}
							if ($config->showHits && ! JoomDOCFileSystem::isFolder($item)) {
						?>
								<span class="hits"><?php echo JText::sprintf('JOOMDOC_HITS_INFO', JoomDOCHelper::number($item->hits)); ?></span>
						<?php		
							}
						?>
						<div class="clr"></div>
					</div>
			<?php 
				}
				
				if ($item->document && ($description = JString::trim($item->document->description))) {
			?>
					<p><?php echo JoomDOCString::crop($description, 200); ?></p>
			<?php 
				}
				
			?>	
			<div class="toolbar">
			
				<a class="open" href="<?php echo $viewDocuments; ?>" title=""><?php echo JText::_(JoomDOCFileSystem::isFolder($item) ? 'JOOMDOC_DISPLAY_FOLDER' : 'JOOMDOC_DISPLAY_FILE');?></a>
				
				<?php if ( !JoomDOCFileSystem::isFolder($item)) { ?>
					<a class="download" href="<?php echo JRoute::_(JoomDOCRoute::download($item->getRelativePath(), $alias)); ?>" title=""><?php echo JText::_('JOOMDOC_SITE_DOWNLOAD_FILE'); ?></a>
				
				<?php } ?>
				
				<div class="clr"></div>
				
			</div>
		</div>
<?php		
	}
?>
</div>