<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCViewDocuments extends JoomDOCView {

    /**
     * Current viewed folder.
     *
     * @var JoomDOCFolder
     */
    protected $root;
    /**
     * Filter folder/file name.
     *
     * @var string
     */
    protected $filter;
    /**
     * Request filter state.
     *
     * @var JObject
     */
    public $state;
    /**
     * Support for page listing.
     *
     * @var JPagination
     */
    public $pagination;
        /**
     * Mark that selected directory is root.
     *
     * @var boolean
     */
    public $inRoot;
    /**
     * Display page with folder content.
     *
     * @param $tpl used template
     * @return void
     */
    public function display ($tpl = null) {

        $mainframe =& JFactory::getApplication();
        /* @var $mainframe JSite */
        $document =& JFactory::getDocument();
        /* @var $documents JDocument */

        $config = JoomDOCConfig::getInstance();
        /* @var $config JoomDOCConfig */

        $modelDocument =& JModel::getInstance(JOOMDOC_DOCUMENT, JOOMDOC_MODEL_PREFIX);
        /* @var $modelDocument JoomDOCModelDocument */
        $modelDocuments = $this->getModel();
        /* @var $modelDocuments JoomDOCModelDocuments */
        $modelFile =& JModel::getInstance(JOOMDOC_FILE, JOOMDOC_MODEL_PREFIX);
        /* @var $modelFile JoomDOCModelFile */

        // get root path from request or config
        $path = JoomDOCString::urldecode(JString::trim(JRequest::getString('path')));
        // path from request can be document full alias - search for path in document table
        $candidate = $modelDocument->searchRelativePathByFullAlias($path);

        if ($candidate) {
            $path = $candidate;
        }

        // convert to absolute path
        $path = $path ? JoomDOCFileSystem::getFullPath($path) : $config->path;
        $this->inRoot = $path == $config->path;

        $this->filter = $mainframe->getUserStateFromRequest('JOOMDOC_DOCUMENTS_FILTER_' . $path, 'filter', '', 'string');
        // get content of selected folder
        $this->root = JoomDOCFileSystem::getFolderContent($path, $this->filter);

        // request path value isn't subfolder od document root
        if (!JoomDOCFileSystem::isSubFolder($path, $config->path)) {
            if ($config->path !== false || $config->docroot !== false) {
                // if set menu item document root or global document root - redirect to root
                $mainframe->redirect(JoomDOCRoute::viewDocuments(JoomDOCFileSystem::getRelativePath($config->path !== false ? $config->path : $config->docroot)), JText::_('JOOMDOC_REDIRECT_DOCROOT'), 'message');
            } else {
                // document root not available - redirect homepage
                $mainframe->redirect('/', JText::_('JOOMDOC_NO_AVAILABLE'), 'notice');
            }
        }

        if (JoomDOCFileSystem::isFolder($this->root)) {
            // selected path is folder
            $modelDocuments->setState(JoomDOCView::getStateName(JOOMDOC_FILTER_PATHS), $this->root->getPaths());
            // get child documents
            $this->documents = $modelDocuments->getItems();
            // get subfolders and files paths
            $this->root->getPaths();
            $this->state = $modelDocuments->getState();
            $this->pagination = $modelDocuments->getPagination();
            // add documents to given subfolders and files
            $this->root->setDocuments($this->documents);
            // reorder
            $this->root->reorder($config->documentOrdering, $config->fileOrdering, JOOMDOC_ORDER_ASC);

        } elseif (JoomDOCFileSystem::isFile($this->root)) {
            // use different layout
            $this->setLayout('file');
            // search document by path
            $this->root->document = $modelDocument->getItemByPath($this->root->getRelativePath());
            // document unpublished
            if ($this->root->document && $this->root->document->published == JOOMDOC_STATE_UNPUBLISHED) {
                JError::raiseWarning(403, JText::_('JERROR_ALERTNOAUTHOR'));
                return;
            }
            $this->root->parent =& $modelDocument->getParent(JoomDOCFileSystem::getParentPath($this->root->getRelativePath()));
                    } else {
            JError::raiseWarning(404, JText::_('JERROR_LAYOUT_PAGE_NOT_FOUND'));
            return;
        }
        // take candidates for metadata sort on priority
        if ($this->root->document) {
            // from document data
            if (!class_exists('JParameter')) {
                jimport('joomla.html.parameter');
            }
            $params = new JParameter($this->root->document->params);
            $titles[] = JString::trim($this->root->document->title);
            $metakeywords[] = JString::trim($params->getValue('metakeywords'));
            $metadescriptions[] = JString::trim($params->getValue('metadescription'));
            $metadescriptions[] = JoomDOCHelper::getMetaDescriptions($this->root->document->description);
        }
        // default candidates
        $titles[] = $this->root->getRelativePath();
        $titles[] = $config->defaultTitle;
        $metakeywords[] = $config->defaultMetakeywords;
        $metadescriptions[] = $config->defaultMetadescription;

        // set meta data from candidates acording to priority

        // set meta keywords
        $document->setMetaData('keywords', JoomDOCHelper::getFirstNoEmpty($metakeywords));
        // set page title
        $document->setTitle(JoomDOCHelper::getCompletTitle(JoomDOCHelper::getFirstNoEmpty($titles)));
        // set head meta description
        $document->setDescription(JoomDOCHelper::getFirstNoEmpty($metadescriptions));

        parent::display($tpl);
    }
}
?>