<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2006 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 *
 *
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

/**
 * Third-party developers can use the following flag to test whether
 * OpenSEF is installed and activated.
 */
if (defined( '_OPENSEF' )) return;
define( '_OPENSEF', 1 );
define( '_OPENSEF_VERSION', '2.0.0-RC5_SP2' );

$sefAdminPath = $mosConfig_absolute_path . '/administrator/components/com_sef';
require_once( $sefAdminPath . '/sef.class.php' );

$sefConfig =& new JosOpenSEFConfig( $database, true );

if ( $sefConfig->enabled ) {
    $sefEnabled = true;
    $database->setQuery("SELECT * FROM #__opensef_sef_component");
    if ($database->loadResult()) {
        $opensef_components = $database->loadObjectList();
    }
} else {
    $sefEnabled = false;
}
if ($sefEnabled){
    // Author info
    $_VERSION->URL .= '<span style="display:none;"> URL rewriting by <a href="http://www.artio.net">Artio</a>, sponsored by <a href="http://www.traveliana.com/">Traveliana</a>.</span>';
    $_VERSION->COPYRIGHT .= ' URL rewriting by Artio (http://www.artio.net/), sponsored by Traveliana (http://www.traveliana.com/).';
    
    $url_array = explode("/", $_SERVER['REQUEST_URI']);
    $pos = 0;
    $rel_uri = str_replace("/index.php", "", $_SERVER['PHP_SELF']);
    if (substr($rel_uri, 0, 1)=="/") {
        $rel_uri = substr($rel_uri, 1);
        $rel_uri_array = split("/", $rel_uri);
        $rel_uri = $rel_uri_array[count($rel_uri_array)-1];
        $pos = array_search ($rel_uri, $url_array);
        if (!$pos) $pos = 0;
    }
    if ( eregi("option,", $_SERVER['REQUEST_URI']) ) {
        if ( !eregi("option,", $url_array[$pos+1]) ) {
            foreach ($url_array as $value) {
                if (eregi("option,", $value)) {
                    $temp = explode(",", $value);
                    $component_name = $temp[1];
                    break;
                }
            }
        }
    } else {
        if (!empty($_POST['option']) && empty($component_name)){
            $component_name = $_POST['option'];
        }
    }
    if (!empty($component_name) OR !empty($_POST['option'])) {
        if (@$_POST['option'] == 'login'
        OR $component_name == 'com_registration'
        OR $component_name == 'com_user'
        OR $component_name == 'com_smf'
        OR $component_name == 'com_phpshop'
        OR $component_name == 'com_virtuemart'
        OR $component_name == 'com_comprofiler'
        OR $component_name == 'com_cbelogin'
        OR $component_name == 'com_cblogin'
        OR $component_name == 'com_cbloginrc2'
        OR $component_name == 'com_smf_registration' )
        {
            $sefEnabled = false;
        } else {
            $sefEnabled = true;
        }
        if(count($opensef_components) > 0){
            foreach($opensef_components as $component){
                if ( @$component_name == $component->component && $component->block == '1'  ) {
                    $sefEnabled = false;
                }
            }
        }
    }
    if (eregi("/com_facileforms/", $_SERVER['REQUEST_URI'])
    OR eregi("searchword=", $_SERVER['REQUEST_URI'])
    // ARTIO: commented
    //OR eregi("mosmsg=", $_SERVER['REQUEST_URI'])
    OR eregi("index2.php", $_SERVER['REQUEST_URI'])
    OR eregi("administrator/index.php", $_SERVER['REQUEST_URI'])
    AND @$_POST['option'] != 'com_contact'
    ) {
        $sefEnabled = false;
    }
    if ($_SERVER['REQUEST_URI'] == 'index.php'){
        $sefEnabled = false;
    }
    if (isset($_POST['jos_change_template'])) $sefEnabled = false;
}



if (defined( '_ADMIN_OFFLINE' )) {
    if (!empty( $mosConfig_sef )) {
        // Joomla!'s SEF option is enabled but Extensions is disabled; revert
        // to using Joomla!'s standard SEF URLs (e.g. /content/view/1/2/)
        require_once( $mosConfig_absolute_path . '/includes/sef.php' );
    } else {
        // Joomla!'s SEF option is turned off; revert to Joomla!'s original-style
        // URLs (e.g. index.php?option=content&task=view&id=1&Itemid=2)
        // We define a dummy sefRelToAbs that actually doesn't do anything.
        function sefRelToAbs( $string ) { return $string;  }
    }
    return;
}

if (!$sefEnabled) {
    // Check whether Search Engine Friendly URLs have been enabled in Joomla!'s
    // Global Configuration. This setting is found under the SEO tab.
    if (!empty( $mosConfig_sef )) {
        // Joomla!'s SEF option is enabled but Extensions is disabled; revert
        // to using Joomla!'s standard SEF URLs (e.g. /content/view/1/2/)
        require_once( $mosConfig_absolute_path . '/includes/sef.php' );
    } else {
        // Joomla!'s SEF option is turned off; revert to Joomla!'s original-style
        // URLs (e.g. index.php?option=content&task=view&id=1&Itemid=2)
        // We define a dummy sefRelToAbs that actually doesn't do anything.
        function sefRelToAbs( $string ) { return $string;  }
    }
    return; // Skip the rest of this file.
}

unset( $sefEnabled ); // Obviously, we're on.

// Joomla!'s SEF option and Extensions are both enabled; we're good to
// go! Include all necessary code for Extensions to handle incoming
// URL requests.
if (!empty( $sefConfig->debug_for_ip )) {
    if ($sefConfig->debug_for_ip == $_SERVER['REMOTE_ADDR'])
    $sefConfig->debug = '1';
}
// Include any OpenSEF 3rd-party extensions. This interface is still
// experimental and subject to change, but this will allow an easy
// way of overriding most of OpenSEF's, and some of Joomla!'s, functionality.
if (!empty( $sefConfig->use_core_ext )) {
    $sefExtPath = $sefAdminPath . '/extensions';
    $sefExtPattern = '^core\\.[\\w\\d]+\\.php$';
    foreach (mosReadDirectory( $sefExtPath, $sefExtPattern  ) as $sefExtFile)
    @include_once( $sefExtPath . '/' . $sefExtFile );
    unset( $sefExtFile, $sefExtPath, $sefExtPattern );
}
// Load core functions *after* any core extensions in order to allow
// for 3PD to override pretty much all our functionality:
require_once( 'sef.functions.php' );

if (!empty( $sefConfig->use_multisite )) {
    $sefSite =& JosOpenSEFSite::lookup(
    $_SERVER['HTTP_HOST'], $_SERVER['REQUEST_URI'] );
}
if (!isset( $sefSite )) {
    $sefSite =& JosOpenSEFSite::getDefault();
    // For any undefined site aliases (wildcard DNS?), redirect browser
    // to the default site
    //if (!empty( $sefConfig->use_canonical_sites )) {
    /*if (strpos( $mosConfig_live_site, '://' . $_SERVER['HTTP_HOST'] ) === false) {
    die( 'Host=' . $_SERVER['HTTP_HOST'] );
    header();
    }*/
    //}
}
if ($sefSite->id == null) $sefSite->id = -1;
$query = "SELECT * FROM #__opensef_sef WHERE published = '1'" .
"\nAND valid = '1'" .
"\nAND (direction IS NULL OR direction = '' OR direction = 'o')" .
"\nAND (site_id IS NULL " .
($sefSite->id ? ' OR site_id = ' . $sefSite->id : '') . ')' .
"\nORDER BY site_id DESC, published DESC, valid DESC, LENGTH(direction) DESC";
$database->setQuery( $query );
if ($database->loadResult()) {
    $opensef_aliases = $database->loadObjectList();
}
// Enforce site-wide security rules and policies.
if (!empty( $sefConfig->enable_security )) {
    define( '_OPENSEF_SECURITY', 1 );
    // TODO: security won't be implemented until 2.0.1 or 2.0.2
    $sefSecurityHandler =& sefLoadSecurityHandler( $database, $sefConfig, $sefSite );
    unset( $sefClassName, $sefSecurity );
}
// Override Joomla! configuration globals from the site configuration
if (!empty( $sefConfig->use_multisite ) && !$sefSite->isDefault()) {
    include( 'configuration.php' );
    $sefSite->overrideGlobals();
}
// Display offline page and end processing if the site is offline
if (!empty( $mosConfig_offline )) {
    die( include( 'offline.php' ) );
}
if (!empty( $sefConfig->enable_sef ) || 1) {
    define( '_OPENSEF_ENABLED', 1 );

    $sefResolver =& sefLoadResolver( $database, $sefConfig, $sefSite );

    if (!empty( $sefConfig->use_automap )) {
        $sefAutoMapper =& sefLoadAutoMapper(
        $database, $sefConfig, $sefSite );
        $sefResolver->setAutoMapper( $sefAutoMapper );
    }

    $sefURL = $_SERVER['REQUEST_URI'];

    if (1) {
        $sefResolver->resolve( $sefURL );
    }
    while(list($key,$value)=each($_GET)) {
        if ($key!="GLOBALS") {
            $GLOBALS[$key]=$value;
        }
    }
    // Don't allow config vars to be passed as global
    include( 'configuration.php' );
    if (!empty( $sefConfig->debug )) {
        //@print_r( $_GET );
        foreach ($sefResolver->getLog() as $sefLog)
        @print_r( $sefLog . '<br />' );
        unset( $sefLog );
    }
    unset( $sefClassName, $sefResolver, $sefAutoMapper, $sefURL );
}
// If OpenSEF (com_sef) is called directly from the frontend (can't think of a
// reason why somebody would do this), let's show a short product blurb in
// place of the pathway. This is AFAIK pretty much the only thing we can do
// in the frontend since sef.php was require_once'd already at the beginning
// of Joomla!'s index.php and thus won't get a chance to be called again when
// mosMainBody() is invoked in the template. C'est la vie.
if (!empty( $option ) && $option == 'com_sef') {
    function sefHandleFrontendRequest( $s ) {
        $pattern = '#(<span class="pathway">).*(</span>)#';
        $text = 'SEF powered by OpenSEF ' . _OPENSEF_VERSION . ' for Joomla!';
        $link = 'http://www.open-sef.org/';
        $banner = '<a href="' . $link . '" target="_blank">' . $text . '</a>';
        return preg_replace( $pattern, '\\1' . $banner . '\\2', $s );
    }
    ob_start( 'sefHandleFrontendRequest' );
    return;
}
?>