<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewDocuments */

// component configuration
$config = &JoomDOCConfig::getInstance();


// list order criteria from user state
$listOrder = $this->escape($this->state->get(JOOMDOC_FILTER_ORDERING));
$listDirn = $this->escape($this->state->get(JOOMDOC_FILTER_DIRECTION));

// browse list allow set items ordering
$ordering = $listOrder == JOOMDOC_ORDER_ORDERING;
// user can change state (ordering) from component global config
$canOrder = JoomDOCAccessDocument::editState($this->rootDocid, $this->rootRelativePath);

$taskOrderUp = JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_ORDERUP);
$taskOrderDown = JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_ORDERDOWN);

$user = &JFactory::getUser();
/* @var $user JUser logged user */

// favorite states
$states[0]['task'] = 'favorite';
$states[1]['task'] = 'unfavorite';

$states[0]['text'] = 'JOOMDOC_SET_FAVORITE';
$states[1]['text'] = 'JOOMDOC_SET_UNFAVORITE';

$states[0]['icon'] = JURI::base(true).'/images/publish_x.png';
$states[1]['icon'] = JURI::base(true).'/images/tick.png';

$states[0]['active_title'] = $states[1]['inactive_title'] = 'JOOMDOC_STANDARD_TTL';
$states[1]['active_title'] = $states[0]['inactive_title'] = 'JOOMDOC_FAVORITE_TTL';

$states[0]['active_class'] = $states[0]['inactive_class'] = 'notdefault';
$states[1]['active_class'] = $states[1]['inactive_class'] = 'default';

$states[0]['tip'] = $states[1]['tip'] = true;

$files = $folders = array();

?>
<div id="joomdoc">

	<div id="pathway">
<?php
	$separator = '';
	$separatorValue = JText::_('JOOMDOC_PATHWAY_SEPARATOR');	
    foreach (JoomDOCFileSystem::getPathBreadCrumbs($this->rootRelativePath) as $i => $breadCrumb) {
?>
		<span class="item">
			<?php echo $separator; ?>
			<a href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($breadCrumb->path)); ?>" class="hasTip" title="<?php echo $this->getTooltip($breadCrumb->path, 'JOOMDOC_DOCUMENTS_OPEN_FOLDER'); ?>"><?php echo $breadCrumb->name; ?></a>
		</span>		
<?php
		$separator = $separatorValue;	
	}	
    if (! $this->inRoot) { 
?>	
		<a class="back" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments(JoomDOCFileSystem::getParentPath($this->rootRelativePath))); ?>" title=""><?php echo JText::_('JOOMDOC_BACK'); ?></a>
<?php } ?>		
	</div>

	<form action="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($this->rootRelativePath)); ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
		<fieldset id="filter-bar">
			<div>
				<label for="filter" class="hasTip filter-search-lbl" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_FILTER'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_FILTER'); ?>:</label>
				<input type="text" name="filter" id="filter" value="<?php echo $this->escape($this->filter); ?>" />
				<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button type="button" onclick="var f=this.form;f.filter.value='';f.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
				
				<?php 
					if (JoomDOCAccessFileSystem::uploadFile($this->rootDocid, $this->rootRelativePath)) { 
				?>
						<label for="upload" class="hasTip filter-search-lbl" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_UPLOADFILE'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_UPLOADFILE'); ?>:</label>			
						<input type="file" name="upload" id="upload" />
						<input type="checkbox" name="iszip" id="iszip" value="1" />
						<label class="hasTip filter-search-lbl" for="iszip" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_UNPACK_ZIP'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_UNPACK_ZIP'); ?></label>
						<button type="submit" class="btn" onclick="return JoomDOC.upload(this)"><?php echo JText::_('JOOMDOC_UPLOAD'); ?></button>
				<?php 
					} 
				 	if (JoomDOCAccessFileSystem::newFolder($this->rootDocid, $this->rootRelativePath)) {

				 		$method = 'return JoomDOC.mkdir(this, \'' . addslashes(JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_NEWFOLDER)) . '\', \'' . JText::_('JOOMDOC_MKDIR_EMPTY', true) . '\',\'' . JText::_('JOOMDOC_MKDIR_FILE_EXISTS', true) . '\',\'' . JText::_('JOOMDOC_MKDIR_DIR_EXISTS', true) . '\')';
				 		
				?>
						<label class="hasTip filter-search-lbl" for="newfolder" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS_NEW_FOLDER'); ?>"><?php echo JText::_('JOOMDOC_DOCUMENTS_NEW_FOLDER'); ?>:</label>
						<input type="text" name="newfolder" id="newfolder" value="<?php echo $this->escape(JRequest::getString('newfolder')); ?>" onchange="<?php echo $method; ?>" />
						<button type="submit" class="btn" onclick="<?php echo $method; ?>"><?php echo JText::_('JOOMDOC_CREATE'); ?></button>
				<?php } ?>
			</div>
		</fieldset>
		<table class="adminlist" cellspacing="1">
			<thead>
				<tr>
					<th width="1%"><input type="checkbox" name="checkall-toggle" value="" onclick="checkAll(this)" /></th>
					<th><?php echo JHtml::_('grid.sort',  'JOOMDOC_DOCUMENTS_ITEM', JOOMDOC_ORDER_PATH, $listDirn, $listOrder); ?></th>
					<th width="1%">&nbsp;</th>
															<th width="1%"><?php echo JHtml::_('grid.sort',  'JOOMDOC_UPLOADED', JOOMDOC_ORDER_UPLOAD, $listDirn, $listOrder); ?></th>
					<th width="1%"><?php echo JText::_('JOOMDOC_SIZE'); ?></th>
					<th width="20%"><?php echo JHtml::_('grid.sort',  'JOOMDOC_DOCUMENT', JOOMDOC_ORDER_TITLE, $listDirn, $listOrder); ?></th>
					<th width="1%"><?php echo JText::_('JOOMDOC_PUBLISHED'); ?></th>
					<th width="1%"><?php echo JText::_('JOOMDOC_FAVORITE'); ?></th>
					<th width="10%">
						<?php 
							echo JHtml::_('grid.sort', 'JGRID_HEADING_ORDERING', JOOMDOC_ORDER_ORDERING, $listDirn, $listOrder);
							$count = $this->pagination->total = $this->root->getItemsCount();
						 	if ($canOrder && $ordering) {
								// create a fake array of browse list items
								for ($i = 0; $i < $count; $i++)
									$fake[] = $i;
							 	echo JHtml::_('grid.order', isset($fake) ? $fake : array(), 'filesave.png', JoomDOCHelper::getTask(JOOMDOC_DOCUMENTS, JOOMDOC_TASK_SAVEORDER));
						 	}
						 ?>
					</th>
					<th width="1%"><?php echo JText::_('JOOMDOC_ACCESS'); ?></th>
					<th width="1%"><?php echo JText::_('JOOMDOC_ID'); ?></th>
					<th width="1%"><?php echo JHtml::_('grid.sort', 'JOOMDOC_HITS', JOOMDOC_ORDER_HITS, $listDirn, $listOrder); ?></th>
				</tr>
			</thead>
			<tbody id="tdoc">
				<?php 
					$this->root->initIteration();
	
					$i = 0;
					
					while ($this->root->hasNext()){
						
						// previous item
						$prevItem = $this->root->getNext(JOOMDOC_ORDER_PREV);
						// next item
						$nextItem = $this->root->getNext(JOOMDOC_ORDER_NEXT);
						// current item
						$item = $this->root->getNext();
						
						$prevItemDocid = JoomDOCHelper::getDocumentID($prevItem);
						$nextItemDocid = JoomDOCHelper::getDocumentID($nextItem);
						
						// quick informations about item
						$docid = JoomDOCHelper::getDocumentID($item);
						$isFile = JoomDOCFileSystem::isFile($item);
						$isFolder = JoomDOCFileSystem::isFolder($item);
						$relativePath = $item->getRelativePath();
						$absolutePath = $item->getAbsolutePath();
						$name = $item->getFileName();
						
						// save files/folders names for next using
						$isFile ? $files[] = $name : $folders[] = $name;
						
						// items is checked with other user
						$isChecked = JoomDOCHelper::isChecked($item);
						$isLocked = false;
												
						// check access
						$canViewFileInfo = JoomDOCAccessFileSystem::viewFileInfo($docid, $relativePath);
						$canRename = JoomDOCAccessFileSystem::rename($docid, $relativePath);
						$canWebDav = JoomDOCAccessFileSystem::editWebDav($docid, $relativePath);
						$canEdit = $docid && JoomDOCAccessDocument::canEdit($item->document);
						$canCreate = JoomDOCAccessDocument::create($relativePath);
						$canDownload = JoomDOCAccessFileSystem::download($docid, $relativePath);
						$canEnterFolder = JoomDOCAccessFileSystem::enterFolder($docid, $relativePath);
						$canEditState = $docid && JoomDOCAccessDocument::editState($docid, $item->document->checked_out);
				?>
	
						<tr class="row<?php echo $i % 2; ?>">
							<td class="center">
				<?php
								if ($item->document) {
									if ($isChecked) {
										echo JHtml::_('jgrid.checkedout', $i, $item->document->editor, $item->document->checked_out_time, 'documents.', (JoomDOCAccessDocument::manage($item->document->checked_out) && JoomDOCAccess::manage()));
									} 
								}
				?>
								<input type="checkbox" name="paths[]" id="cbb<?php echo $i; ?>" value="<?php echo $this->escape($relativePath); ?>" class="blind" />
								<?php if (!$isChecked && !$isLocked) { ?>
									<input type="checkbox" name="cid[]" id="cb<?php echo $i; ?>" value="<?php echo $docid; ?>" onclick="isChecked(this.checked);JoomDOC.check(this,<?php echo $i; ?>)" />
								<?php } ?>
							</td>
							<td class="filepath">
								<?php 
									if ($isFolder) { 
										if ($canEnterFolder) {
								?>
											<a class="hasTip folder" href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments($relativePath)); ?>" title="<?php echo $this->getTooltip($relativePath, 'JOOMDOC_DOCUMENTS_OPEN_FOLDER'); ?>"><?php echo $name; ?></a>
								<?php
										} else { 
								?>
											<a class="folder noLink" href="javascript:void(0)" title=""><?php echo $name; ?></a>
								<?php	
										}
									} else {
										if ($canDownload) { 
								?>
											<a href="<?php echo JRoute::_(JoomDOCRoute::download($relativePath)); ?>" class="hasTip file" title="<?php echo $this->getTooltip($relativePath, 'JOOMDOC_DOWNLOAD_FILE'); ?>"><?php echo $name; ?></a>
								<?php 
										} else {
								?>			
											<a href="javascript:void(0)" class="file noLink" title=""><?php echo $name; ?></a>
								<?php
										}
									}
									if ($canRename) {
								?>
									
										<div class="rename blind">
											<input type="text" name="rename" value="<?php echo $this->escape($name); ?>" />
											<button onclick="return JoomDOC.rename(this, '<?php echo addslashes(JoomDOCHelper::getTask(JOOMDOC_DOCUMENT, JOOMDOC_TASK_RENAME)); ?>', '<?php echo addslashes($name); ?>', '<?php echo addslashes($relativePath); ?>', '<?php echo JText::_('JOOMDOC_RENAME_SAME_NAME', true); ?>', '<?php echo JText::_('JOOMDOC_RENAME_EMPTY_NAME', true); ?>', '<?php echo JText::_('JOOMDOC_RENAME_FILE_EXISTS', true); ?>', '<?php echo JText::_('JOOMDOC_RENAME_DIR_EXISTS', true); ?>')"><?php echo JText::_('JOOMDOC_RENAME_SAVE'); ?></button>
											<button onclick="return JoomDOC.closeRename(this, '<?php echo addslashes($name); ?>')"><?php echo JText::_('JOOMDOC_RENAME_CLOSE'); ?></button>
										</div>
								<?php } ?>
							</td>
							
							<td class="rename">
								<?php if ($canRename) { ?>
									<a href="javascript:void(0)" class="rename" id="openRename<?php echo $i; ?>" onclick="JoomDOC.openRename(<?php echo $i; ?>)" title="<?php echo JText::_('JOOMDOC_RENAME', true); ?>"></a>
								<?php } ?>	
							</td>	
							
														
														
							<td>
								<?php
									if ($canViewFileInfo) { 
										echo isset($item->upload) ? JoomDOCHelper::uploaded($item->upload, false) : '';
									} 
								?>
							</td>
							<td>
								<?php 
									if ($canViewFileInfo) {
										echo $isFolder ? '-' : $item->getFileSize();
									} 
								?>
							</td>
				
							<?php if ($docid) { ?>
				
							<td>
					
								<?php
									if ($canEdit) {
								?>
										<a href="<?php echo JRoute::_(JoomDOCRoute::editDocument($docid)); ?>" title="<?php echo $this->getTooltip($item->document->title, 'JOOMDOC_EDIT_DOCUMENT'); ?>" class="hasTip"><?php echo $this->escape($item->document->title); ?></a>
								<?php
									} else { 
										echo $this->escape($item->document->title);
									}
								?>
					
							</td>
					
							<td class="center" align="center">
								<?php 
									echo JHtml::_('jgrid.published', $item->document->state, $i, 'documents.', $canEditState, 'cb', $item->document->publish_up, $item->document->publish_down); 
								?>
							</td>
							
							<td class="center" align="center">
								<?php 
									echo JHtml::_('jgrid.state', $states, $item->document->favorite, $i, 'documents.', $canEditState, true); 
								?>
							</td>
					
							<td class="order">
								<?php 
									if ($canEditState) {
							 			if ($ordering) {
								 			if ($listDirn == 'asc') { 
								?>
												<span><?php echo $this->pagination->orderUpIcon($i, $prevItemDocid, $taskOrderUp, 'JLIB_HTML_MOVE_UP', $ordering); ?></span>
												<span><?php echo $this->pagination->orderDownIcon($i, $this->pagination->total, $nextItemDocid, $taskOrderDown, 'JLIB_HTML_MOVE_DOWN', $ordering); ?></span>
								<?php 
											} elseif ($listDirn == 'desc') {
								?>
												<span><?php echo $this->pagination->orderUpIcon($i, $prevItemDocid, $taskOrderDown, 'JLIB_HTML_MOVE_UP', $ordering); ?></span>
												<span><?php echo $this->pagination->orderDownIcon($i, $this->pagination->total, $nextItemDocid, $taskOrderUp, 'JLIB_HTML_MOVE_DOWN', $ordering); ?></span>
								<?php 
											} 
										} 
								?>
										<input type="text" name="order[<?php echo $docid; ?>]" size="5" value="<?php echo $item->document->ordering;?>" <?php if (!$ordering) { ?>disabled="disabled"<?php } ?> class="text-area-order" />
								<?php 
									} else
										echo $item->document->ordering;
								?>
							</td>
					
							<td class="center"><?php echo $this->escape($item->document->access_title); ?></td>
							<td class="center"><?php echo JoomDOCHelper::number($item->document->id); ?></td>
					
						<?php } else { ?>
							<td colspan="6">
								<?php if ($canCreate) { ?>
									<a href="<?php echo JRoute::_(JoomDOCRoute::addDocument($relativePath)); ?>" class="hasTip addDocument" title="<?php echo $this->getTooltip('JOOMDOC_ADD_DOCUMENT'); ?>"></a>
								<?php } ?>
							</td>
						<?php } ?>
						<td class="center"><?php echo JoomDOCHelper::number($item->hits); ?></td>
					</tr>			
				<?php 
					$i ++;
					}
					if (empty($files) && empty($folders)) {
				?>
						<tr><td colspan="20"><?php echo JText::_('JOOMDOC_EMPTY_FOLDER'); ?></td></tr>
				<?php } ?>
			</tbody>
		</table>		
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<input type="hidden" name="renamePath" value="" />
		<input type="hidden" name="newName" value="" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
<?php 
	JoomDOCHelper::jsArray('joomDOCFiles', $files);
	JoomDOCHelper::jsArray('joomDOCFolders', $folders);
?>