<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/* @var $this JoomDOCViewJoomDOC */

$data = &JApplicationHelper::parseXMLInstallFile(JOOMDOC_MANIFEST);
$xml = J16 ? JFactory::getXML(JOOMDOC_MANIFEST) : J16Factory::getXML(JOOMDOC_MANIFEST);
$license = $xml->license;
$licenser = $xml->licenser;
?>
<div id="cpanel">
	<div class="icon-wrapper">
		<div class="hasTip icon" title="<?php echo $this->getTooltip('JOOMDOC_DOCUMENTS'); ?>">
			<a href="<?php echo JRoute::_(JoomDOCRoute::viewDocuments()); ?>" title="" >
				<img src="<?php echo JOOMDOC_IMAGES; ?>icon-48-documents.png" alt="" />
				<span><?php echo JText::_('JOOMDOC_DOCUMENTS'); ?></span>
			</a>
		</div>
		<div class="hasTip icon" title="<?php echo $this->getTooltip('JOOMDOC_UPGRADE'); ?>">
			<a href="<?php echo JRoute::_(JoomDOCRoute::viewUpgrade()); ?>" title="" >
				<img src="<?php echo JOOMDOC_IMAGES; ?>icon-48-upgrade.png" alt="" />
				<span><?php echo JText::_('JOOMDOC_UPGRADE'); ?></span>
			</a>
		</div>
	</div>
	<div class="col width-35" style="width: 35%;float: right;">
		<fieldset class="adminform">
			<legend><?php echo JText::_('JOOMDOC'); ?></legend>
			<table class="admintable">
		   		<tr>
					<td class="key"></td>
					<td>
		      			<a href="<?php echo JRoute::_($data['authorUrl']); ?>" target="_blank" title="">
		          			<img src="<?php echo JOOMDOC_IMAGES; ?>icon-120-joomdoc.png" alt="" />
		        		</a>
					</td>
				</tr>
		   		<tr>
		      		<td class="key" width="120"></td>
		      		<td><a href="<?php echo JRoute::_($data['authorUrl']); ?>" target="_blank"><?php echo JText::_('JOOMDOC'); ?></a></td>
		   		</tr>	
		   		<tr>
		      		<td class="key"><?php echo JText::_('JOOMDOC_VERSION'); ?></td>
		      		<td>
		      			<strong><?php echo $data['version']; ?></strong>
		      			
		      			<?php echo JText::sprintf('JOOMDOC_EXTEND', JOOMDOC_URL_FEATURES, JOOMDOC_URL_ESHOP); ?>
		      					
		      		</td>
		   		</tr>
		   		<tr>
		      		<td class="key"><?php echo JText::_('JOOMDOC_DATE'); ?></td>
		      		<td><?php echo JHTML::date(isset($data['creationdate']) ? $data['creationdate'] : $data['creationDate'], JText::_('DATE_FORMAT_LC4')); ?></td>
		   		</tr>
		   		<tr>
		      		<td class="key" valign="top"><?php echo JText::_('JOOMDOC_COPYRIGHT'); ?></td>
		      		<td>&copy; 2006 - <?php echo date('Y'); ?>, <?php echo $data['author']; ?></td>
		   		</tr>
		   		<tr>
		      		<td class="key"><?php echo JText::_('JOOMDOC_AUTHOR'); ?></td>
		      		<td><a href="<?php echo $data['authorUrl']; ?>" target="_blank"><?php echo $data['author']; ?></a>,
		      		<a href="mailto:<?php echo $data['authorEmail']; ?>"><?php echo $data['authorEmail']; ?></a></td>
		   		</tr>
		   		<tr>
		      		<td class="key" valign="top"><?php echo JText::_('JOOMDOC_DESCRIPTION'); ?></td>
		      		<td><?php echo JText::_('JOOMDOC_DESC'); ?></td>
		   		</tr>
		   		<tr>
		      		<td class="key"><?php echo JText::_('JOOMDOC_LICENSE'); ?></td>
		      		<td><a href="<?php echo $license; ?>" target="_blank" class="hasTip" title="<?php echo $this->getTooltip('JOOMDOC_LICENSER'); ?>"><?php echo $licenser; ?></a></td>
		   		</tr>
			</table>
		</fieldset>
	</div>
	<div class="clr"></div>
</div>