<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

/**
 * Process custom events after JoomDOC3 installing through Joomla installer.
 */
function com_install()
{
    /* Load Joomla framework */
    $db = JFactory::getDbo();
    /* @var $db JDatabase */
    $document = JFactory::getDocument();
    /* @var $document JDocument */
    $language = JFactory::getLanguage();
    /* @var $language JLanguage */
    $mainframe = JFactory::getApplication();
    /* @var $mainframe JApplication */
    // Add style it this way because in Joomla 1.7.2 doesn't work placing CSS into page head during component installation
    echo '<style type="text/css">';
    echo '<!--';
    echo '#JoomDOCInstall{padding: 10px;}';
    echo '#JoomDOCInstall h2{color: #B7CF5F;margin: 0;padding: 15px 0;}';
    echo '#JoomDOCInstall p{margin: 0;text-align: justify;width: 50%;}';
    echo '#JoomDOCInstall a{color: #B7CF5F;display: block;font-size: 1.1em;font-weight: bold;padding: 10px 0;}';
    echo '#JoomDOCInstall img{float: left;margin: 0 10px 0 0;}';
    echo '#JoomDOCInstall form{padding: 15px 0;}';
    echo '-->';
    echo '</style>';
    // load component language
    $language->load('com_joomdoc', JPATH_ADMINISTRATOR);
    // recognized process of installation
    $installation = class_exists('JInstaller');
    // install component extensions
    if ($installation) {
        // register JoomDOC installer to extend Joomla installer
        JLoader::register('AInstaller', JPATH_ROOT . '/administrator/components/com_joomdoc/libraries/joomdoc/installer/installer.php');
        AInstaller::install(JPATH_ROOT . '/administrator/components/com_joomdoc/extensions');
    }
    // current database prefix
    $pr = $mainframe->getCfg('dbprefix');
    // all tables in Joomla database
    $joomla = $db->getTableList();
    // all JoomDOC2 tables
    $joomdoc = array($pr . 'joomdoc', $pr . 'joomdoc_groups', $pr . 'joomdoc_history', $pr . 'joomdoc_licenses', $pr . 'joomdoc_log');
    // all JoomDOC2 tables in backup form
    $joomdocBckp = array($pr . 'joomdoc2', $pr . 'joomdoc2_groups', $pr . 'joomdoc2_history', $pr . 'joomdoc2_licenses', $pr . 'joomdoc2_log');
    // all DocMAN tables
    $docman = array($pr . 'docman', $pr . 'docman_groups', $pr . 'docman_history', $pr . 'docman_licenses', $pr . 'docman_log');
    echo '<div id="JoomDOCInstall">';
    if ($installation) {
        // introduction about JoomDOC3
        echo '<h2>' . JText::_('JOOMDOC') . '</h2>';
        echo '<img src="' . JURI::root(true) . '/components/com_joomdoc/assets/images/icon-48-joomdoc.png" alt="" />';
        echo '<p>' . JText::_('JOOMDOC_DESC') . JText::_('JOOMDOC_INSTALL_INFO') . '</p>';
        echo '<p><a href="' . JRoute::_('index.php?option=com_joomdoc') . '" title="">' . JText::_('JOOMDOC_OPEN') . '</a></p>';
    }
    $nothingToMigrate = true;
    if (array_intersect($joomdoc, $joomla) == $joomdoc || array_intersect($joomdocBckp, $joomla) == $joomdocBckp) {
        // JoomDOC2 was installed, prompt user to migrate data from JoomDOC2 into JoomDOC3
        echo '<h2>' . JText::_('JOOMDOC_JOOMDOC2_FOUND') . '</h2>';
        echo '<img src="' . JURI::root(true) . '/components/com_joomdoc/assets/images/icon-48-joomdoc2.png" alt="" />';
        echo '<p>' . JText::_('JOOMDOC_JOOMDOC2_MIGRATION_INFO') . '</p>';
        echo '<form id="joomdoc2import" name="joomdoc2import" method="post" action="index.php?option=com_joomdoc&amp;task=migration.run&amp;component=joomdoc">';
        echo '<label for="docbase">' . JText::_('JOOMDOC_JOOMDOC2_MIGRATION_LABEL') . '</label>';
        echo '<input type="text" name="docbase" id="docbase" value="" size="50" />';
        echo '<button onclick="if(this.form.docbase.value.trim()==\'\'){alert(\'' . JText::_('JOOMDOC_MIGRATION_ADD_DOCBASE', true) . '\');return false;}else{this.form.submit();}">' . JText::_('JOOMDOC_JOOMDOC2_MIGRATION_BUTTON') . '</button>';
        echo '</form>';
        if ($installation) {
            // rename JoomDOC2 tables because there is collision with JoomDOC3 - only during installation
            $db->setQuery('RENAME TABLE #__joomdoc TO #__joomdoc2');
            $db->query();
            $db->setQuery('RENAME TABLE #__joomdoc_groups TO #__joomdoc2_groups');
            $db->query();
            $db->setQuery('RENAME TABLE #__joomdoc_history TO #__joomdoc2_history');
            $db->query();
            $db->setQuery('RENAME TABLE #__joomdoc_licenses TO #__joomdoc2_licenses');
            $db->query();
            $db->setQuery('RENAME TABLE #__joomdoc_log TO #__joomdoc2_log');
            $db->query();
            // run JoomDOC3 database installation again because some tables for JoomDOC3 are missing after renaming
            $queries = JFile::read(JPATH_ROOT . '/administrator/components/com_joomdoc/sql/install.mysql.utf8.sql');
            $queries = $db->splitSql($queries);
            foreach ($queries as $query) {
                $db->setQuery($query);
                $db->query();
            }
        }
        $nothingToMigrate = false;
    }
    if (array_intersect($docman, $joomla) == $docman) {
        // DocMAN was installed, prompt user to migrate data from JoomDOC2 into JoomDOC3
        echo '<h2>' . JText::_('JOOMDOC_DOCMAN_FOUND') . '</h2>';
        echo '<img src="' . JURI::root(true) . '/components/com_joomdoc/assets/images/icon-48-docman.png" alt="" />';
        echo '<p>' . JText::_('JOOMDOC_DOCMAN_MIGRATION_INFO') . '</p>';
        echo '<form id="docmanimport" name="docmanimport" method="post" action="index.php?option=com_joomdoc&amp;task=migration.run&amp;component=docman">';
        echo '<label for="docbase2">' . JText::_('JOOMDOC_DOCMAN_MIGRATION_LABEL') . '</label>';
        echo '<input type="text" name="docbase" id="docbase2" value="" size="50" />';
        echo '<button onclick="if(this.form.docbase.value.trim()==\'\'){alert(\'' . JText::_('JOOMDOC_MIGRATION_ADD_DOCBASE', true) . '\');return false;}else{this.form.submit();}">' . JText::_('JOOMDOC_DOCMAN_MIGRATION_BUTTON') . '</button>';
        echo '</form>';
        $nothingToMigrate = false;
    }
    if (!$installation && $nothingToMigrate) {
        $mainframe->enqueueMessage(JText::sprintf('JOOMDOC_MIGRATION_NOTHING_TO_DO', implode(', ', $docman), implode(', ', $joomdocBckp)), 'notice');
    }
    echo '</div>';
}
?>