<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

$base = dirname(__FILE__);

JLoader::register('ArtioReinstall', $base . '/helper.php');
JLoader::register('JoomDOCInstaller', $base . '/../admin/install.joomdoc.php');

JFile::copy('joomdoc.xml', 'admin/joomdoc.xml', $base . '/..');
JFile::copy('license.txt', 'admin/license.txt', $base . '/..');

/* Update component admin */
ArtioReinstall::addFilesOp($this, 'administrator/components/com_joomdoc', 'admin');
/* Update component site */
ArtioReinstall::addFilesOp($this, 'components/com_joomdoc', 'site');
/* Update admin language */
ArtioReinstall::addFilesOp($this, 'administrator/language', 'language/admin', false);
/* Update site language */
ArtioReinstall::addFilesOp($this, 'language', 'language/site', false);
/* Update search plugin */
ArtioReinstall::addFilesOp($this, 'plugins/search/joomdoc', 'admin/extensions/plg_search_joomdoc');
/* Update editors-xtd plugin */
ArtioReinstall::addFilesOp($this, 'plugins/editors-xtd/joomdoc', 'admin/extensions/plg_editors-xtd_joomdoc');
/* Update search module - only if installed */
if (JFolder::exists("$base/../../../modules/mod_joomdoc_search"))
    ArtioReinstall::addFilesOp($this, 'modules/mod_joomdoc_search', 'admin/extensions/mod_joomdoc_search');
/* Update combo module - only if installed */
if (JFolder::exists("$base/../../../modules/mod_joomdoc"))
    ArtioReinstall::addFilesOp($this, 'modules/mod_joomdoc', 'admin/extensions/mod_joomdoc');
/* Update explorer module - only if installed */
if (JFolder::exists("$base/../../../modules/mod_joomdoc_explorer"))
	ArtioReinstall::addFilesOp($this, 'modules/mod_joomdoc_explorer', 'admin/extensions/mod_joomdoc_explorer');

/* Check database */
ArtioReinstall::doSql($this, $base . '/../admin/sql/install.mysql.utf8.sql');
?>