<?php
/**
 * Artio DOCman2 2.0.0 - Joomla! Document Manager
 * @version     $Id: factory.php $
 * @package     DOCman2
 * @subpackage  helpers
 * @copyright	Copyright (C) 2009 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 **/
class DocmanFactory {
	function getDocman() {
	    global $mainframe;
		static $instance;
		if (! is_object ( $instance )) {
			$instance = new dmMainFrame ( );
			if($mainframe->isSite()){
		        $instance->loadLanguage ( 'frontend' );
			}
		}
		return $instance;
	}
	function getDmuser() {
		static $instance;
		if (! is_object ( $instance )) {
			$docman = DocmanFactory::getDocman ();			
			$instance = $docman->getUser ();
		}
		return $instance;
	}
	function setTheme(&$docman, $theme, $icon_theme = '') {
		$theme = str_replace ( JPATH_ROOT, '', $theme );
		$docman->setCfg('themes',$theme);
		//$docman->_path->themes = $theme;
		$docman->setCfg ( $icon_theme, '' );
	}
	function getPathName($p_path, $p_addtrailingslash = true) {
		jimport ( 'joomla.filesystem.path' );
		$path = JPath::clean ( $p_path );
		if ($p_addtrailingslash) {
			$path = rtrim ( $path, DS ) . DS;
		}
		return $path;
	}
	function getToolTip($tooltip, $title = '', $width = '', $image = 'tooltip.png', $text = '', $href = '', $link = 1) {
		// Initialize the toolips if required
		static $init;
		if (! $init) {
			JHTML::_ ( 'behavior.tooltip' );
			$init = true;
		}
		
		return JHTML::_ ( 'tooltip', $tooltip, $title, $image, $text, $href, $link );
	}
	function getFormatDate($date = 'now', $format = null, $offset = null) {
		
		if (! $format) {
			$format = JText::_ ( 'DATE_FORMAT_LC1' );
		}
		
		return JHTML::_ ( 'date', $date, $format, $offset );
	}
	function getImageCheckAdmin($file, $directory = '/images/', $param = NULL, $param_directory = '/images/', $alt = NULL, $name = NULL, $type = 1, $align = 'middle') {
		$attribs = array ('align' => $align );
		return JHTML::_ ( 'image.administrator', $file, $directory, $param, $param_directory, $alt, $attribs, $type );
	}
	function getStripslashes(&$value) {
		$ret = '';
		if (is_string ( $value )) {
			$ret = stripslashes ( $value );
		} else {
			if (is_array ( $value )) {
				$ret = array ();
				foreach ( $value as $key => $val ) {
					$ret [$key] = DocmanFactory::getStripslashes ( $val );
				}
			} else {
				$ret = $value;
			}
		}
		return $ret;
	}
}
?>