<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS')) die('Direct Access to this location is not allowed.');

class sefext_com_fireboard extends sef_joomsef
{

    function create($string, &$vars) {
        extract($vars);
        
        // JF translate extension.
        global $sefConfig, $mainframe, $database;
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

        // load params
        $this->params = SEFTools::getExtParams('com_fireboard');
        $nonSefVars = array();
        $ignoreVars = array();
        
        $catRewrite = true;
        $msgRewrite = true;
        $usrRewrite = true;       

        if ($msgRewrite || $catRewrite) {
            if ($catRewrite && !empty($catid)) {
                $query = "
        		SELECT `name`$jfTranslate
        		FROM `#__fb_categories`
        		WHERE `id` = $catid
        		";
                $database->setQuery($query);
                $catTitle = $database->loadResult();
            }
            if (isset($id)) $msgID = $id;
            elseif (isset($msg_id)) $msgID = $msg_id;
            elseif (isset($replyto)) $msgID = $replyto;
            else $msgID = null;
            if ($msgRewrite && !empty($msgID)) {
                $query = "
        		SELECT `subject`$jfTranslate
        		FROM `#__fb_messages`
        		WHERE `id` = $msgID
        		";
                $database->setQuery($query);
                $msgTitle = $database->loadResult();
            }
        }
        if ($usrRewrite && isset($userid)) {
            $query = "
        	SELECT `username`
        	FROM `#__users`
        	WHERE `id` = $userid
        	";
            $database->setQuery($query);
            $usrTitle = $database->loadResult();
        }
        
        // Set non-sef vars according to settings
        $doOptimize = in_array(@$do, array('reply', 'quote', 'delete', 'edit', 'move', 'sticky', 'lock'))
        || (isset($func) && $func == 'report');
        if ($this->params->get('idExclude', true) && $doOptimize) {
            if (isset($id)) $nonSefVars['id'] = $id;
            if (isset($replyto)) $nonSefVars['replyto'] = $replyto;
            if (isset($msg_id)) $nonSefVars['msg_id'] = $msg_id;
        }
        if ($this->params->get('optimize', true) && $doOptimize) {
            if (isset($fb_thread)) $nonSefVars['fb_thread'] = $fb_thread;
            if (isset($name)) $nonSefVars['name'] = $name;
        }
        // this needs to follow previous that use do
        if ($this->params->get('doExclude', true)) {
            if (isset($do)) $nonSefVars['do'] = $do;
            unset($do);
        }
        
        // if task is not set, use do
        if (empty($task) && isset($func) && $func == 'post' && isset($do)) {
            $task = $do;
            unset($func); unset($do);
        }
        
        if (empty($task) && isset($func)) {
            $task = $func;
            unset($func);
        }

        // First subdir
        if (!empty($option)) {
            $title[] = getMenuTitle($option, @$task, @$Itemid);
        }

        // Category
        if (isset($catTitle) && !empty($catTitle)) {
            $title[] = $catTitle;
        }

        // Topic
        if (isset($msgTitle) && !empty($msgTitle)) {
            $title[] = (!isset($do) && !isset($func)) ? $msgTitle.$sefConfig->suffix : $msgTitle;
        }
        
        // Selection
        if (@$task == 'latest' && $sel) {
            $task .= '-'.$sel;
        }
        
        // View
        if (isset($view)) {
            $title[] = (!isset($do) && !isset($func)) ? $view.$sefConfig->suffix : $view;
        }
               
        // User
        if (isset($usrTitle) && !empty($usrTitle)) {
            if ($func == 'fbprofile') {
                $title[] = 'users';
                $func = null;
            }
            $title[] = !isset($do) ? $usrTitle.$sefConfig->suffix : $usrTitle;
        }
            
        if (isset($page) && $page > 1) {
            $title[] = $page;
        }
        
        // Func and do
        if (isset($do) || isset($func)) {
            if (isset($func)) $oper[] = $func;
            if (isset($do))   $oper[] = $do;
            $title[] = join('-', $oper).$sefConfig->suffix;
        }               
        
        if( in_array(@$task, array('showcat', 'view')) ) {
            unset($task);
        }
        
        if (count($title) > 0) {
            $string = sef_joomsef::sefGetLocation($string, $title, @$task, @$limit, @$limitstart, @$lang, $nonSefVars, $ignoreVars);
        }
        
        return $string;
    }
}
?>
