<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

class VmsmsModelDashboard extends VmsmsModel
{
    public function getLists()
    {
        $config = VmsmsConfig::getInstance();
        
        $lists = array();
        
        // Prepare a credit purchase list
        $lists['credit_amount'] = '';
        $lists['purchase_link'] = '';
        if (!empty($config->username) && !empty($config->apiKey)) {
            $api = AVmsmsSmsService::getInstance();
            $data = $api->getCreditPurchaseInfo();
            
            $values = $data['creditValues'];
            
            $vals = array();
            $vals[] = JHtml::_('select.option', '', JText::_('COM_VMSMS_SELECT_CREDIT'));
            foreach ($values as $value => $text) {
                $vals[] = JHtml::_('select.option', $value, $text);
            }
            $lists['credit_amount'] = JHtml::_('select.genericlist', $vals, 'credit_amount');
            
            $lists['purchase_link'] = $data['link'];
        }
        
        // Custom SMS
        $lists['sms_phone'] = '<input type="text" name="sms_phone" id="sms_phone" value="" onblur="VMSMS.hideAutoComplete();" onkeydown="VMSMS.handleKey(event);" onkeyup="VMSMS.showAutoComplete(this, event, \'find_phones\');" />';
        $lists['sms_text'] = '<textarea name="sms_text" id="sms_text" cols="50" rows="4"></textarea>';
        
        return $lists;
    }
    
    public function getCreditInfo()
    {
        $config = VmsmsConfig::getInstance();
        if (empty($config->username) || empty($config->apiKey)) {
            return false;
        }
        
        $sms = AVmsmsSmsService::getInstance();
        $info = $sms->getCreditInfo($config->username, $config->apiKey);
        
        return $info;
    }
    
    public function getComponentInfo()
    {
        $info = array();
        
        jimport('joomla.filesystem.file');
        
        $xmlFile = JPATH_ADMINISTRATOR.'/components/com_vmsms/manifest.xml';
        if (JFile::exists($xmlFile)) {
            $xml = simplexml_load_file($xmlFile);
            if ($xml !== false) {
                $info['version'] = (string)$xml->version;
                $info['creationDate'] = (string)$xml->creationDate;
                $info['author'] = (string)$xml->author;
                $info['authorEmail'] = (string)$xml->authorEmail;
                $info['authorUrl'] = (string)$xml->authorUrl;
                $info['copyright'] = (string)$xml->copyright;
                $info['license'] = (string)$xml->license;
                $info['description'] = JText::_((string)$xml->description);
            }
        }
            
        return $info;
    }
    
    public function getNewVersion()
    {
        $result = '?.?.?';
        $http = AVmsmsHttpHelper::getInstance();
        
        $response = $http->sendRequest(VmsmsConfig::$newVersionUrl);
        if (!$response || $response->code != 200) {
            return $result;
        }
        
        $xml = simplexml_load_string($response->content);
        if (!$xml) {
            return $result;
        }
        
        foreach ($xml->children() as $package) {
            $element = (string)$package->element;
            $version = (string)$package->version;
            
            if ($element == 'com_vmsms') {
                $result = $version;
                break;
            }
        }
        
        return $result;
    }
}
