<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

$config = VmsmsConfig::getInstance();
?>
<table class="adminform">
    <tr>
        <td>
            <a href="http://www.artio.net/sms-services/logs" target="_blank"><?php echo JText::_('COM_VMSMS_LOGS_OPEN_ALL'); ?></a>
        </td>
    </tr>
</table>

<table class="adminlist table table-striped">
    <thead>
        <tr>
            <th width="80"><?php echo JText::_('COM_VMSMS_LOGS_DATE'); ?></th>
            <th width="80"><?php echo JText::_('COM_VMSMS_LOGS_TIME'); ?></th>
            <th width="120"><?php echo JText::_('COM_VMSMS_LOGS_ACTION'); ?></th>
            <th><?php echo JText::_('COM_VMSMS_LOGS_DESCRIPTION'); ?></th>
            <th width="120"><?php echo JText::_('COM_VMSMS_LOGS_NUMBER'); ?></th>
            <th width="80"><?php echo JText::_('COM_VMSMS_LOGS_CREDIT'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (!is_array($this->logs)) {
            // Error when loading logs
            echo '<tr><td colspan="6">'.JText::_('COM_VMSMS_ERR_LOGS').'</td></tr>';
        }
        else if (count($this->logs) == 0) {
            // No logs
            echo '<tr><td colspan="6">'.JText::_('COM_VMSMS_NO_LOGS').'</td></tr>';
        }
        else {
            $k = 0;
            foreach ($this->logs as $row) {
                ?>
                <tr class="row<?php echo ($k++ % 2); ?>">
                    <td><?php echo date('d.m.Y', $row->timestamp); ?></td>
                    <td><?php echo date('H:i:s', $row->timestamp); ?></td>
                    <td><?php echo htmlspecialchars($row->actionText); ?></td>
                    <td><?php echo htmlspecialchars($row->desc); ?></td>
                    <td><?php echo htmlspecialchars($row->number); ?></td>
                    <td style="text-align: right;"><?php echo ($row->credit > 0 ? '+' : '').htmlspecialchars($row->credit); ?></td>
                </tr>
                <?php
            }
        }
        ?>
    </tbody>
</table>
