<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

/**
 * Initialization
 */
jimport('joomla.installer.installer');

$db = JFactory::getDBO();
$src = $this->parent->getPath('source');

$status = new stdClass;
$status->plugins = array();

// Load language file
$lang = JFactory::getLanguage();
$lang->load('com_vmsms');

// Check if this is update or new installation by checking if there's already our plugin installed
$isUpdate = JFile::exists(JPATH_SITE.'/plugins/vmshipment/vmsms.php');

// Load helper to check VM version
require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/helper.php');

// If this is fresh install and VM1 is installed, copy order data to our table
if (!$isUpdate && VmsmsHelper::isVm1()) {
    $query = "INSERT INTO `#__vmsms_order_status` (`vm_order_id`, `last_status`)";
    $query .= " SELECT `vm`.`order_id`, `vm`.`order_status`";
    $query .= " FROM `#__vm_orders` AS `vm`";
    $db->setQuery($query);
    $db->query();
}

$app = JFactory::getApplication();

// Check if VM is installed
if (!VmsmsHelper::isVm1() && !VmsmsHelper::isVm2()) {
    // Display message
    $app->enqueueMessage(JText::_('COM_VMSMS_VM_NOT_INSTALLED'), 'notice');
}
else if (!$isUpdate) {
    // VM installed, get shop owner country code
    $countrySet = false;
    $country = null;
    if (VmsmsHelper::isVm1()) {
        // VM 1
        $q = "SELECT c.`country_name`, c.`country_3_code`"
            ." FROM `#__vm_vendor` v"
            ." INNER JOIN `#__vm_country` c ON (c.country_3_code = v.vendor_country)"
            ." WHERE v.`vendor_id` = 1";
        $db->setQuery($q);
        $country = $db->loadObject();
    }
    else {
        // VM 2, get shop owner user ID
        $db->setQuery("SELECT `virtuemart_user_id` FROM `#__virtuemart_vmusers` WHERE `virtuemart_vendor_id` = 1");
        $uid = intval($db->loadResult());
        if ($uid > 0) {
            // Get VM shop owner country code
            $q = "SELECT c.`country_name`, c.`country_3_code`"
                ." FROM `#__virtuemart_userinfos` u"
                ." INNER JOIN `#__virtuemart_countries` c ON (c.virtuemart_country_id = u.virtuemart_country_id)"
                ." WHERE u.`virtuemart_user_id` = {$uid} AND u.`address_type` = 'BT'";
            $db->setQuery($q);
            $country = $db->loadObject();
        }
    }
    
    if (is_object($country)) {
        $code = $country->country_3_code;
        
        // Try to obtain country calling code
        $dial = VmsmsHelper::getCountryDialCode($code);
        if ($dial !== false) {
            // Set local country to VM SMS configuration
            require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/config.php');
            $config = VmsmsConfig::getInstance();
            $config->localCountry = array('country_code' => $code, 'dial_code' => $dial);
            $config->save();
            
            $app->enqueueMessage(JText::sprintf('COM_VMSMS_SET_LOCAL_COUNTRY', $country->country_name), 'notice');
            $countrySet = true;
        }
    }
    
    if (!$countrySet) {
        $app->enqueueMessage(JText::_('COM_VMSMS_LOCAL_COUNTRY_NOT_SET'), 'notice');
    }
}

/**
 * Install plugins
 */
$plugins = $this->manifest->getElementByPath('plugins');
if (is_a($plugins, 'JSimpleXMLElement') && count($plugins->children())) {
    foreach ($plugins->children() as $plugin) {
        $pname = $plugin->attributes('name');
        $pgroup = $plugin->attributes('group');
        $path = $src.'/plugins/'.$pgroup.'/'.$pname;
        $installer = new JInstaller;
        $result = $installer->install($path);
        $query = "UPDATE `#__plugins` SET `published` = 1 WHERE `element` = ".$db->Quote($pname)." AND `folder` = ".$db->Quote($pgroup);
        $db->setQuery($query);
        $db->query();
        $status->plugins[] = array('name' => $pname, 'group' => $pgroup, 'result' => $result);
    }
}

/**
 * Display the installation status
 */
$rows = 0;
?>
<h2><?php echo JText::_('COM_VMSMS_INSTALL_STATUS'); ?></h2>
<table class="adminlist">
    <tr>
        <th colspan="2"><?php echo JText::_('COM_VMSMS_EXTENSION'); ?></th>
        <th><?php echo JText::_('COM_VMSMS_STATUS'); ?></th>
    </tr>
    <tr class="row0">
        <td class="key" colspan="2"><?php echo JText::_('COM_VMSMS_COMPONENT'); ?></td>
        <td><strong><?php echo JText::_('COM_VMSMS_INSTALLED'); ?></strong></td>
    </tr>
    <?php
    if (count($status->plugins)) {
        ?>
        <tr>
            <th><?php echo JText::_('COM_VMSMS_PLUGIN'); ?></th>
            <th><?php echo JText::_('COM_VMSMS_PLG_GROUP'); ?></th>
            <th></th>
        </tr>
        <?php
        foreach ($status->plugins as $plugin) {
            ?>
            <tr class="row<?php echo(++$rows % 2); ?>">
                <td class="key"><?php echo $plugin['name']; ?></td>
                <td class="key"><?php echo $plugin['group']; ?></td>
                <td><strong><?php echo ($plugin['result'] ? JText::_('COM_VMSMS_INSTALLED') : JText::_('COM_VMSMS_NOT_INSTALLED')); ?></strong></td>
            </tr>
        <?php
        }
    }
    ?>
</table>

<?php
/**
 * Display the How to start
 */
// Load requried CSS
$doc = JFactory::getDocument();
$doc->addStyleSheet(JURI::base(true).'/components/com_vmsms/assets/css/general.css');

// Load mootools
JHtml::_('behavior.modal');

// Display the How to start tutorial
?>
<h2>How to Start</h2>
<div class="hts_tile">
    <h2>Step 1: Register ARTIO account</h2>
    <p>If you already have an ARTIO website account, just <a href="http://www.artio.net/user-login/login" target="_blank">log in</a> and continue with Step 2.</p>
    <p>Otherwise, <a href="http://www.artio.net/user-login/create-an-account" target="_blank">register</a> a new ARTIO website account:</p>
    <p class="img">
        <a href="components/com_vmsms/assets/images/register.png" class="modal">
            <img src="components/com_vmsms/assets/images/register.png" alt="Registration" width="250" />
        </a>
    </p>
</div>
<div class="hts_tile">
    <h2>Step 2: Activate SMS Services</h2>
    <p>Once you are logged in to ARTIO website, <a href="http://www.artio.net/sms-services/activation" target="_blank">activate</a> an SMS Service account:</p>
    <p class="img">
        <a href="components/com_vmsms/assets/images/activate.png" class="modal">
            <img src="components/com_vmsms/assets/images/activate.png" alt="Activation" width="250" />
        </a>
    </p>
</div>
<div class="hts_tile">
    <h2>Step 3: Charge initial credit</h2>
    <p>If you select to charge initial credit during previous step, you will be taken to the checkout page, so just finish the order:</p>
    <p class="img">
        <a href="components/com_vmsms/assets/images/checkout.png" class="modal">
            <img src="components/com_vmsms/assets/images/checkout.png" alt="Initial credit" width="250" />
        </a>
    </p>
</div>
<div class="hts_tile">
    <h2>Step 4: Find your API key</h2>
    <p><a href="http://www.artio.net/sms-services/dashboard" target="_blank">Open</a> your SMS Service dashboard and find your username and API key:</p>
    <p class="img">
        <a href="components/com_vmsms/assets/images/apikey.png" class="modal">
            <img src="components/com_vmsms/assets/images/apikey.png" alt="API key" width="250" />
        </a>
    </p>
</div>
<div class="hts_tile">
    <h2>Step 5: Set your API key</h2>
    <p>Then <a href="index.php?option=com_vmsms&amp;view=config" target="_blank">open</a> your new ARTIO VM SMS Configuration page and set your username, API key and the fields your VM users use for phone numbers:</p>
    <p class="img">
        <a href="components/com_vmsms/assets/images/basic_config.png" class="modal">
            <img src="components/com_vmsms/assets/images/basic_config.png" alt="Basic Configuration" width="250" />
        </a>
    </p>
</div>
<div class="hts_tile">
    <h2>Step 6: Configure SMS</h2>
    <p>Still on the ARTIO VM SMS Configuration page, set if you want to send SMS to you or your customer for each VM status:</p>
    <p class="img">
        <a href="components/com_vmsms/assets/images/sms_config.png" class="modal">
            <img src="components/com_vmsms/assets/images/sms_config.png" alt="SMS Configuration" width="250" />
        </a>
    </p>
</div>
<div class="hts_tile">
    <h2>Step 7: You're ready to go!</h2>
    <p>Congratulations, you've successfully set up your ARTIO VM SMS!</p>
    <p>You can now continue to the ARTIO VM SMS dashboard: <a href="index.php?option=com_vmsms">ARTIO VM SMS Dashboard</a></p>
</div>
<div class="clear"></div>
