<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   1.0.4
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

/**
 * Initialization
 */
jimport('joomla.installer.installer');

$db = JFactory::getDBO();

$status = new stdClass;
$status->plugins = array();

// Load language file
$lang = JFactory::getLanguage();
$lang->load('com_vmsms');

/**
 * Uninstall plugins
 */
$plugins = $this->manifest->getElementByPath('plugins');
if (is_a($plugins, 'JSimpleXMLElement') && count($plugins->children())) {
    foreach ($plugins->children() as $plugin) {
        $pname = $plugin->attributes('name');
        $pgroup = $plugin->attributes('group');
        $query = 'SELECT `id` FROM `#__plugins` WHERE `element` = '.$db->Quote($pname).' AND `folder` = '.$db->Quote($pgroup);
        $db->setQuery($query);
        $plugs = $db->loadResultArray();
        if (count($plugs))
        {
            foreach ($plugs as $plugin)
            {
                $installer = new JInstaller;
                $result = $installer->uninstall('plugin', $plugin, 0);
            }
        }
        $status->plugins[] = array('name' => $pname, 'group' => $pgroup, 'result' => $result);
    }
}

/**
 * Display the uninstallation status
 */
$rows = 0;
?>
<h2><?php echo JText::_('COM_VMSMS_UNINSTALL_STATUS'); ?></h2>
<table class="adminlist">
    <tr>
        <th colspan="2"><?php echo JText::_('COM_VMSMS_EXTENSION'); ?></th>
        <th><?php echo JText::_('COM_VMSMS_STATUS'); ?></th>
    </tr>
    <tr class="row0">
        <td class="key" colspan="2"><?php echo JText::_('COM_VMSMS_COMPONENT'); ?></td>
        <td><strong><?php echo JText::_('COM_VMSMS_UNINSTALLED'); ?></strong></td>
    </tr>
    <?php
    if (count($status->plugins)) {
        ?>
        <tr>
            <th><?php echo JText::_('COM_VMSMS_PLUGIN'); ?></th>
            <th><?php echo JText::_('COM_VMSMS_PLG_GROUP'); ?></th>
            <th></th>
        </tr>
        <?php
        foreach ($status->plugins as $plugin) {
            ?>
            <tr class="row<?php echo(++$rows % 2); ?>">
                <td class="key"><?php echo $plugin['name']; ?></td>
                <td class="key"><?php echo $plugin['group']; ?></td>
                <td><strong><?php echo ($plugin['result'] ? JText::_('COM_VMSMS_UNINSTALLED') : JText::_('COM_VMSMS_NOT_UNINSTALLED')); ?></strong></td>
            </tr>
        <?php
        }
    }
    ?>
</table>
