<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

$config = VmsmsConfig::getInstance();
?>
<div class="col width-60">
    <ul id="vmsms_autocomplete" style="display: none;"><li>dummy</li></ul>

    <form action="<?php echo htmlspecialchars($this->lists['purchase_link']); ?>" method="post" name="buyCreditForm" id="buyCreditForm" style="display: none;" target="_blank">
        <input type="hidden" name="username" value="<?php echo $config->username; ?>" />
        <input type="hidden" name="api_key" value="<?php echo $config->apiKey; ?>" />
        <input type="hidden" name="credit" value="" />
    </form>

    <fieldset class="adminform">
        <legend><?php echo JText::_('COM_VMSMS_BASIC_INFO'); ?></legend>

        <table class="adminform table table-striped">
            <tr>
                <td class="key"><label for="username"><?php echo JText::_('COM_VMSMS_CONFIG_USERNAME'); ?>:</label></td>
                <td><?php echo $config->username; ?></td>
            </tr>
            <tr>
                <td class="key"><label for="apiKey"><?php echo JText::_('COM_VMSMS_CONFIG_API_KEY'); ?>:</label></td>
                <td><?php echo $config->apiKey; ?></td>
            </tr>
        </table>

        <table class="adminform table table-striped">
            <?php
            if (!is_array($this->creditInfo)) {
                ?>
                <tr>
                    <td><?php echo JText::_('COM_VMSMS_ERR_CREDIT_INFO'); ?></td>
                </tr>
                <?php
            }
            else {
                ?>
                <tr>
                    <td class="key"><label><?php echo JText::_('COM_VMSMS_CREDIT'); ?>:</label></td>
                    <td><?php echo (isset($this->creditInfo['credit']) ? $this->creditInfo['credit'].' '.JText::_('COM_VMSMS_CREDIT_CREDITS') : ''); ?></td>
                </tr>
                <tr>
                    <td class="key"><label><?php echo JText::_('COM_VMSMS_EXHAUSTION'); ?>:</label></td>
                    <td><?php echo (isset($this->creditInfo['exhaustion']) ? $this->creditInfo['exhaustion'].' '.JText::_('COM_VMSMS_EXHAUSTION_HOURS') : ''); ?></td>
                </tr>
                <tr>
                    <td class="key"><label for="credit_amount"><?php echo JText::_('COM_VMSMS_CHARGE_CREDIT'); ?>:</label></td>
                    <td>
                        <?php echo $this->lists['credit_amount']; ?>
                        <input type="button" value="<?php echo JText::_('COM_VMSMS_CHARGE_SUBMIT'); ?>" onclick="VMSMS.buyCredit();" />
                    </td>
                </tr>
                <?php
            }
            ?>
        </table>
    </fieldset>

    <fieldset class="adminform">
        <legend><?php echo JText::_('COM_VMSMS_CUSTOM_SMS'); ?></legend>

        <table class="adminform table table-striped">
            <?php
            if (!is_array($this->creditInfo)) {
                ?>
                <tr>
                    <td><?php echo JText::_('COM_VMSMS_ERR_CUSTOM_SMS_NOT_AVAILABLE'); ?></td>
                </tr>
                <?php
            }
            else {
                ?>
                <tr>
                    <td class="key"><label for="sms_phone"><?php echo JText::_('COM_VMSMS_CUSTOM_SMS_PHONE'); ?>:</label></td>
                    <td><?php echo $this->lists['sms_phone']; ?></td>
                </tr>
                <tr>
                    <td class="key"><label for="sms_text"><?php echo JText::_('COM_VMSMS_CUSTOM_SMS_TEXT'); ?>:</label></td>
                    <td>
                        <?php echo $this->lists['sms_text']; ?>
                        <br class="clr"/>
                        <span class="sms_counter" id="sms_counter_sms_text">0 / 0</span>
                    </td>
                </tr>
                <tr>
                    <td class="key">&nbsp;</td>
                    <td>
                        <input type="button" name="sms_send" id="sms_send" value="<?php echo JText::_('COM_VMSMS_CUSTOM_SMS_SEND'); ?>" onclick="VMSMS.sendCustomSMS();" />
                        <span id="ajax_working" style="display: none;">
                            <img src="<?php echo JURI::base(true); ?>/components/com_vmsms/assets/images/ajax-loader-small.gif" />
                        </span>
                        <span id="ajax_err" style="display: none;"></span>
                        <span id="ajax_success" style="display: none;"><?php echo JText::_('COM_VMSMS_CUSTOM_SMS_SENT'); ?></span>
                    </td>
                </tr>
                <?php
            }
            ?>
        </table>
        <script type="text/javascript">
            VMSMS.initSmsCounters();
        </script>
    </fieldset>
</div>

<div class="col width-40 vmsms_dashboard">
    <fieldset class="adminform">
        <legend><?php echo JText::_('COM_VMSMS'); ?></legend>

        <table class="admintable">
            <tr>
                <td class="key"></td>
                <td>
                    <a href="http://www.artio.net/virtuemart-tools/vm-sms" target="_blank">
                        <img src="components/com_vmsms/assets/images/box.png" alt="VM SMS Logo" style="border: none; margin: 8px;" />
                    </a>
                </td>
            </tr>
            <tr>
                <td class="key"></td>
                <td><?php echo JText::_('COM_VMSMS'); ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo JText::_('COM_VMSMS_VERSION'); ?>:</td>
                <td><?php echo $this->info['version']; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo JText::_('COM_VMSMS_NEW_VERSION'); ?>:</td>
                <td><?php echo $this->newVersion; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo JText::_('COM_VMSMS_DATE'); ?>:</td>
                <td><?php echo $this->info['creationDate']; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo JText::_('COM_VMSMS_COPYRIGHT'); ?>:</td>
                <td>Copyright &copy; <?php echo date('Y').' '.$this->info['copyright']; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo JText::_('COM_VMSMS_AUTHOR'); ?>:</td>
                <td>
                    <a href="<?php echo $this->info['authorUrl']; ?>" target="_blank"><?php echo $this->info['author']; ?></a>,
                    <a href="mailto:<?php echo $this->info['authorEmail']; ?>"><?php echo $this->info['authorEmail']; ?></a>
                </td>
            </tr>
            <tr>
                <td class="key"><?php echo JText::_('COM_VMSMS_DESCRIPTION_LBL'); ?>:</td>
                <td><?php echo $this->info['description']; ?></td>
            </tr>
            <tr>
                <td class="key"><?php echo JText::_('COM_VMSMS_LICENSE'); ?>:</td>
                <td><?php echo $this->info['license']; ?></td>
            </tr>
        </table>
    </fieldset>
</div>
