<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

class VmsmsConfig
{
    public static $newVersionUrl = "http://www.artio.cz/updates/joomla/vmsms2/version.xml";
    
    public $username = '';
    public $apiKey = '';
    public $sendUser = array();
    public $sendCustomer = array();
    public $userText = array();
    public $customerText = array();
    public $primary_phone = 'phone_1';
    public $secondary_phone = 'phone_2';
    public $localCountry = array('country_code' => 'USA', 'dial_code' => '1'); // [ country_code => code, dial_code => code ]
    public $localCountryMinDigits = '9';
    public $includeNumbers = array(); // [ dial_code => [ country_code => code, filters => array() ] ]
    public $excludeNumbers = array(); // [ dial_code => [ country_code => code, filters => array() ] ]
    public $allowUnicode = 0;
    
    private static $instance = null;
    
    private function __construct()
    {
        // Load configuration from component params
		$params = JComponentHelper::getParams('com_vmsms');
        
        $vars = get_object_vars($this);
        foreach ($vars as $var => $val) {
            // Joomla loads JSON to objects, make sure to convert them to arrays
            $this->$var = $this->objToArray($params->get($var, $val));
        }
    }
    
    private function objToArray($obj)
    {
        if (is_object($obj)) {
            $obj = (array)$obj;
        }
        
        if (is_array($obj)) {
            // We must store data in new array to overcome an issue in PHP with string/numeric keys:
            // object converted to array has all the keys as strings, but you can't use the key like '2'
            // when assigning to array, becuase it's converted to integer, so you end up with an array like:
            // [ '1' => object, 1 => array ]
            $new = array();
            foreach ($obj as $key => $val) {
                $new[$key] = $this->objToArray($val);
            }
            
            return $new;
        }
        else {
            return $obj;
        }
    }
    
	public static function getInstance()
	{
		if (is_null(self::$instance)) {
			self::$instance = new VmsmsConfig();
		}

		return self::$instance;
	}
    
    public function save()
    {
        // Load current params
        $params = JComponentHelper::getParams('com_vmsms');
        
        // Update them
        $vars = get_object_vars($this);
        foreach ($vars as $var => $val) {
            $params->set($var, $this->$var);
        }
        
        // Save params
        $data = $params->toString();
        $db = JFactory::getDbo();
        $db->setQuery("UPDATE `#__extensions` SET `params` = ".$db->Quote($data)." WHERE `type` = 'component' AND `element` = 'com_vmsms'");
        return $db->query();
    }
    
    public function getSendUser($status)
    {
        return $this->getVarStatus('sendUser', $status, 0);
    }
    
    public function getSendCustomer($status)
    {
        return $this->getVarStatus('sendCustomer', $status, 0);
    }
    
    public function getUserText($status)
    {
        return $this->getVarStatus('userText', $status, '');
    }
    
    public function getCustomerText($status, $lang)
    {
        return $this->getVarLangStatus('customerText', $status, $lang, '');
    }
    
    protected function getVarStatus($var, $status, $def)
    {
        // We must enclose the $var in brackets because [] has higher precedence than ->
        if (isset($this->{$var}) && isset($this->{$var}[$status])) {
            return $this->{$var}[$status];
        }
        
        return $def;
    }
    
    protected function getVarLangStatus($var, $status, $lang, $def)
    {
        // We must enclose the $var in brackets because [] has higher precedence than ->
        if (isset($this->{$var}) && isset($this->{$var}[$status]) && isset($this->{$var}[$status][$lang])) {
            return $this->{$var}[$status][$lang];
        }
        
        return $def;
    }
}
