<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

class VmsmsHelper
{
    protected static $dialCodes = array(
        'AFG' => '93',
        'ALB' => '355',
        'DZA' => '213',
        'ASM' => '1684',
        'AND' => '376',
        'AGO' => '244',
        'AIA' => '1264',
        'ATA' => '672',
        'ATG' => '1268',
        'ARG' => '54',
        'ARM' => '374',
        'ABW' => '297',
        'AUS' => '61',
        'AUT' => '43',
        'AZE' => '994',
        'BHS' => '1242',
        'BHR' => '973',
        'BGD' => '880',
        'BRB' => '1246',
        'BLR' => '375',
        'BEL' => '32',
        'BLZ' => '501',
        'BEN' => '229',
        'BMU' => '1441',
        'BTN' => '975',
        'BOL' => '591',
        'BIH' => '387',
        'BWA' => '267',
        'BRA' => '55',
        'VGB' => '1284',
        'BRN' => '673',
        'BGR' => '359',
        'BFA' => '226',
        'MMR' => '95',
        'BDI' => '257',
        'KHM' => '855',
        'CMR' => '237',
        'CAN' => '1',
        'CPV' => '238',
        'CYM' => '1345',
        'CAF' => '236',
        'TCD' => '235',
        'CHL' => '56',
        'CHN' => '86',
        'CXR' => '61',
        'CCK' => '61',
        'COL' => '57',
        'COM' => '269',
        'COK' => '682',
        'CRC' => '506',
        'HRV' => '385',
        'CUB' => '53',
        'CYP' => '357',
        'CZE' => '420',
        'COD' => '243',
        'DNK' => '45',
        'DJI' => '253',
        'DMA' => '1767',
        'DOM' => '1809',
        'ECU' => '593',
        'EGY' => '20',
        'SLV' => '503',
        'GNQ' => '240',
        'ERI' => '291',
        'EST' => '372',
        'ETH' => '251',
        'FLK' => '500',
        'FRO' => '298',
        'FJI' => '679',
        'FIN' => '358',
        'FRA' => '33',
        'PYF' => '689',
        'GAB' => '241',
        'GMB' => '220',
        'GEO' => '995',
        'DEU' => '49',
        'GHA' => '233',
        'GIB' => '350',
        'GRC' => '30',
        'GRL' => '299',
        'GRD' => '1473',
        'GUM' => '1671',
        'GTM' => '502',
        'GIN' => '224',
        'GNB' => '245',
        'GUY' => '592',
        'HTI' => '509',
        'VAT' => '39',
        'HND' => '504',
        'HKG' => '852',
        'HUN' => '36',
        'IS' => '354',
        'IND' => '91',
        'IDN' => '62',
        'IRN' => '98',
        'IRQ' => '964',
        'IRL' => '353',
        'IMN' => '44',
        'ISR' => '972',
        'ITA' => '39',
        'CIV' => '225',
        'JAM' => '1876',
        'JPN' => '81',
        'JOR' => '962',
        'KAZ' => '7',
        'KEN' => '254',
        'KIR' => '686',
        'KWT' => '965',
        'KGZ' => '996',
        'LAO' => '856',
        'LVA' => '371',
        'LBN' => '961',
        'LSO' => '266',
        'LBR' => '231',
        'LBY' => '218',
        'LIE' => '423',
        'LTU' => '370',
        'LUX' => '352',
        'MAC' => '853',
        'MKD' => '389',
        'MDG' => '261',
        'MWI' => '265',
        'MYS' => '60',
        'MDV' => '960',
        'MLI' => '223',
        'MLT' => '356',
        'MHL' => '692',
        'MRT' => '222',
        'MUS' => '230',
        'MYT' => '262',
        'MEX' => '52',
        'FSM' => '691',
        'MDA' => '373',
        'MCO' => '377',
        'MNG' => '976',
        'MNE' => '382',
        'MSR' => '1664',
        'MAR' => '212',
        'MOZ' => '258',
        'NAM' => '264',
        'NRU' => '674',
        'NPL' => '977',
        'NLD' => '31',
        'ANT' => '599',
        'NCL' => '687',
        'NZL' => '64',
        'NIC' => '505',
        'NER' => '227',
        'NGA' => '234',
        'NIU' => '683',
        'NFK' => '672',
        'PRK' => '850',
        'MNP' => '1670',
        'NOR' => '47',
        'OMN' => '968',
        'PAK' => '92',
        'PLW' => '680',
        'PAN' => '507',
        'PNG' => '675',
        'PRY' => '595',
        'PER' => '51',
        'PHL' => '63',
        'PCN' => '870',
        'POL' => '48',
        'PRT' => '351',
        'PRI' => '1',
        'QAT' => '974',
        'COG' => '242',
        'ROU' => '40',
        'RUS' => '7',
        'RWA' => '250',
        'BLM' => '590',
        'SHN' => '290',
        'KNA' => '1869',
        'LCA' => '1758',
        'MAF' => '1599',
        'SPM' => '508',
        'VCT' => '1784',
        'WSM' => '685',
        'SMR' => '378',
        'STP' => '239',
        'SAU' => '966',
        'SEN' => '221',
        'SRB' => '381',
        'SYC' => '248',
        'SLE' => '232',
        'SGP' => '65',
        'SVK' => '421',
        'SVN' => '386',
        'SLB' => '677',
        'SOM' => '252',
        'ZAF' => '27',
        'KOR' => '82',
        'ESP' => '34',
        'LKA' => '94',
        'SDN' => '249',
        'SUR' => '597',
        'SWZ' => '268',
        'SWE' => '46',
        'CHE' => '41',
        'SYR' => '963',
        'TWN' => '886',
        'TJK' => '992',
        'TZA' => '255',
        'THA' => '66',
        'TLS' => '670',
        'TGO' => '228',
        'TKL' => '690',
        'TON' => '676',
        'TTO' => '1868',
        'TUN' => '216',
        'TUR' => '90',
        'TKM' => '993',
        'TCA' => '1649',
        'TUV' => '688',
        'UGA' => '256',
        'UKR' => '380',
        'ARE' => '971',
        'GBR' => '44',
        'USA' => '1',
        'URY' => '598',
        'VIR' => '1340',
        'UZB' => '998',
        'VUT' => '678',
        'VEN' => '58',
        'VNM' => '84',
        'WLF' => '681',
        'YEM' => '967',
        'ZMB' => '260',
        'ZWE' => '263'
    );
    
    /**
     * Returns a country calling code for given 3 character country code
     * 
     * @param string $iso Country code (3 chars)
     * @return string/bool Country calling code if found, false if not.
     */
    public static function getCountryDialCode($iso)
    {
        if (isset(self::$dialCodes[$iso])) {
            return self::$dialCodes[$iso];
        }
        
        return false;
    }
    
    /**
     * Applies the phone numbers rules to given phone number.
     * Returns valid phone number or false if it doesn't pass the filters.
     */
    public static function checkPhone($phone)
    {
        $config = VmsmsConfig::getInstance();
        
        // Remove spaces and leading plus and zeroes
        $phone = str_replace(' ', '', $phone);
        $phone = ltrim($phone, '+0');
        
        // Add country code if needed
        if (strlen($phone) <= $config->localCountryMinDigits) {
            $phone = $config->localCountry['dial_code'].$phone;
        }
        
        // Check include filters
        foreach ($config->includeNumbers as $dial => $filters) {
            // Try to find the filters for this dial code
            if (strpos($phone, (string)$dial) === 0) {
                // Get number without the dial code
                $number = substr($phone, strlen($dial));
                
                // Check patterns - at least one must be passed
                $passed = false;
                foreach ($filters['filters'] as $pattern) {
                    if (self::checkPattern($number, $pattern)) {
                        $passed = true;
                        break;
                    }
                }
                if (!$passed) {
                    // Number didn't pass
                    return false;
                }
                break;
            }
        }
        
        // Check exclude filters
        foreach ($config->excludeNumbers as $dial => $filters) {
            // Try to find the filters for this dial code
            if (strpos($phone, (string)$dial) === 0) {
                // Get number without the dial code
                $number = substr($phone, strlen($dial));
                
                // Check patterns - none of them can pass
                foreach ($filters['filters'] as $pattern) {
                    if (self::checkPattern($number, $pattern)) {
                        // Number is excluded
                        return false;
                    }
                }
                break;
            }
        }
        
        // Phone number can be used
        return $phone;
    }
    
    /**
     * Checks if given phone number (without the country dial code!) matches given pattern
     */
    private static function checkPattern($number, $pattern)
    {
        if (strpos($pattern, '-') !== false) {
            // Range
            $range = explode('-', $pattern);
            $min = $range[0];
            $max = $range[1];
            
            if (self::checkPatternOp($number, $min, 'min') && self::checkPatternOp($number, $max, 'max')) {
                return true;
            }
        }
        else {
            if (self::checkPatternOp($number, $pattern, 'exact')) {
                return true;
            }
        }
        
        return false;
    }
    
    /**
     * Checks if given number passes given pattern with given operation.
     * $op can be: min, max, exact
     */
    private static function checkPatternOp($number, $pattern, $op)
    {
        $pattern = str_split($pattern);
        $number = str_split($number);
        
        $count = count($pattern);
        $maxNum = count($number);
        for ($i = 0; $i < $count; $i++) {
            $pchar = $pattern[$i];
            
            // Check for asterisk
            if ($pchar == '*') {
                // Asterisk can be only last in the pattern and matches anything
                return true;
            }
            
            // Check length
            if ($i >= $maxNum) {
                // Pattern is longer than number, didn't pass
                return false;
            }
            
            // Check question mark
            if ($pchar == '?') {
                // Matches anything, continue
                continue;
            }
            
            // Check number according to specified operation
            $nchar = $number[$i];
            if (!is_numeric($nchar)) {
                // We can match only numeric symbols now
                return false;
            }
            
            $pnum = intval($pchar);
            $nnum = intval($nchar);
            if ($op == 'exact') {
                if ($pnum != $nnum) {
                    // Didn't pass
                    return false;
                }
            }
            else if ($op == 'min') {
                // Number must be >= pattern
                if ($nnum < $pnum) {
                    // Didn't pass
                    return false;
                }
            }
            else if ($op == 'max') {
                // Number must be <= pattern
                if ($nnum > $pnum) {
                    // Didn't pass
                    return false;
                }
            }
            else {
                // Unknown operation, fail
                return false;
            }
        }
        
        // Passed
        return true;
    }
}
