<?php
/**
 * ARTIO VM SMS
 *
 * @package   ARTIO VM SMS
 * @version   2.0.7
 * @author    ARTIO http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o.
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// no direct access
defined('_JEXEC') or die;

if (!class_exists('vmPSPlugin')) {
    require(JPATH_VM_PLUGINS.'/vmpsplugin.php');
}

/**
 * Use a vmshipment plugin instead of vmpayment, so we can be sure
 * that all the vmpayment plugins were successful
 */
class plgVmShipmentVmsms extends vmPSPlugin
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
    }
    
    public function plgVmOnUpdateOrderShipment(&$data, $old_order_status)
    {
        $newStatus = $data->order_status;
        $orderNum = $data->order_number;
        $total = number_format($data->order_total, 2);
        $userId = intval($data->virtuemart_user_id);
        $orderId = intval($data->virtuemart_order_id);
        $deliveryDate = isset($data->delivery_date) ? $data->delivery_date : '';
        
        // Check if status changed
        if ($newStatus == $old_order_status AND $newStatus!='P') { //fix pama: for new order
            return true;
        }
        
        // Get status ID
        $db = JFactory::getDbo();
        $db->setQuery("SELECT `virtuemart_orderstate_id` FROM `#__virtuemart_orderstates` WHERE `order_status_code` = ".$db->quote($newStatus));
        $state = $db->loadResult();
        if (!$state) {
            return true;
        }
        
        // Load required VM SMS classes
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/config.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/classes/helper.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/lib/httphelper.php');
        require_once(JPATH_ADMINISTRATOR.'/components/com_vmsms/lib/smsservice.php');
        
        // Get config for current state
        $config = VmsmsConfig::getInstance();
        $sendUser = $config->getSendUser($state);
        $sendCustomer = $config->getSendCustomer($state);
        
        if (!$sendUser && !$sendCustomer) {
            // Don't send anything
            return true;
        }
        
        // Load user info
        $user = null;
        if ($userId > 0) {
            $user = JFactory::getUser($userId);
        }
        $sms = AVmsmsSmsService::getInstance();
        
        $customerName = $this->getUsername($orderId);
        
        if ($sendUser) {
            // Send SMS to owner
            $text = $config->getUserText($state);
            $text = $this->replacePlaceholders($text, $orderNum, $total, $customerName, $deliveryDate);
            $sms->sendOwnMessage($config->username, $config->apiKey, $text, $config->allowUnicode, 'vmsms2');
        }
        
        if ($sendCustomer) {
            // Get customer phone number
            $phone = $this->getPhoneNumber($orderId);
            if (!empty($phone)) {
                // Get customer language
                $lang = null;
                if (is_object($user)) {
                    $lang = $user->getParam('language');
                }
                if (empty($lang)) {
                    // Get default website language
                    $params = JComponentHelper::getParams('com_languages');
                    $lang = $params->get('site', 'en-GB');
                }
                
                // Send SMS to customer
                $text = $config->getCustomerText($state, $lang);
                $text = $this->replacePlaceholders($text, $orderNum, $total, $customerName, $deliveryDate);
                $sms->sendMessage($config->username, $config->apiKey, $phone, $text, $config->allowUnicode, 'vmsms2');
            }
        }
        
        return true;
    }
    
    private function getUsername($orderId)
    {
        $db = JFactory::getDbo();
        
        $query = "SELECT `address_type`, `first_name`, `middle_name`, `last_name` FROM `#__virtuemart_order_userinfos` WHERE `virtuemart_order_id` = ".(int)$orderId;
        $db->setQuery($query);
        $names = $db->loadObjectList('address_type');
        
        $name = null;
        if (isset($names['ST'])) {
            $name = $names['ST'];
        }
        else if (isset($names['BT'])) {
            $name = $names['BT'];
        }
        else {
            // No name
            return '';
        }
        
        $parts = array();
        if (!empty($name->first_name)) {
            $parts[] = $name->first_name;
        }
        if (!empty($name->middle_name)) {
            $parts[] = $name->middle_name;
        }
        if (!empty($name->last_name)) {
            $parts[] = $name->last_name;
        }
        
        return implode(' ', $parts);
    }
    
    private function getPhoneNumber($orderId)
    {
        $config = VmsmsConfig::getInstance();
        $db = JFactory::getDbo();
        
        $primary = $config->primary_phone;
        $secondary = $config->secondary_phone;
        
        $query = "SELECT `address_type`, `{$primary}` AS `phone1`, `{$secondary}` AS `phone2` FROM `#__virtuemart_order_userinfos` WHERE `virtuemart_order_id` = ".(int)$orderId;
        $db->setQuery($query);
        $phones = $db->loadObjectList('address_type');
        
        // Prepare array of phone numbers according to priority
        $numbers = array();
        if (isset($phones['ST'])) {
            $numbers[] = $phones['ST']->phone1;
            $numbers[] = $phones['ST']->phone2;
        }
        if (isset($phones['BT'])) {
            $numbers[] = $phones['BT']->phone1;
            $numbers[] = $phones['BT']->phone2;
        }
        
        foreach ($numbers as $phone) {
            if (!empty($phone)) {
                $phone = VmsmsHelper::checkPhone($phone);
                if (is_string($phone)) {
                    return $phone;
                }
            }
        }
        
        return false;
    }
    
    private function replacePlaceholders($text, $orderNum, $orderTotal, $username, $deliveryDate)
    {
        $placeholders = array('%customer%', '%order_nr%', '%order_total%', '%delivery_date%');
        $replace = array($username, $orderNum, $orderTotal, $deliveryDate);
        
        return str_replace($placeholders, $replace, $text);
    }
}
