<?php

/**
 * Popup element to select subject.
 *
 * @package     ARTIO Booking
 * @subpackage  elements
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.modal', 'a.modal');

class JFormFieldSubject extends JFormField
{

    public function getInput()
    {
        JHtml::script('components/com_booking/assets/js/view-subjects.js');

        require_once JPATH_ADMINISTRATOR . '/components/com_booking/defines.php';
        JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_booking/models');
        JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_booking/tables');

        $subjectModel = JModelLegacy::getInstance('Subject', 'BookingModel');
        /* @var $subjectModel BookingModelSubject */
        $subjectModel->setId($this->value);
        $subject = $subjectModel->getObject();

        $html = '<span class="input-append">';
        $html .= '<input class="input-xxlarge" type="text" id="subject_name" value="' . htmlspecialchars($subject->title) . '" disabled="disabled" />';
        $html .= '<a class="modal btn btn-primary" href="' . JRoute::_('index.php?option=com_booking&controller=subject&task=element&tmpl=component&type=' . strval($this->element['use_type'])) . '" rel="{handler: \'iframe\', size: {x: 900, y: 600}}">' . JText::_('JSELECT') . '</a>';
        $html .= '<a class="btn btn-danger" href="javascript:ListSubjects.reset()">' . JText::_('JCLEAR') . '</a>';
        $html .= '</span>';
        $html .= '<input type="hidden" id="subject_id" name="' . $this->name . '" value="' . htmlspecialchars($this->value) . '" />';

        return $html;
    }
}