<?php

/**
 * @version        $Id$
 * @package        ARTIO Booking
 * @subpackage  models
 * @copyright    Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author        ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class BookingModelReservationType extends JModelLegacy
{

    /**
     * @var BookingModelDailyFixedLimit[]
     */
    protected $limits = array();
    /**
     * @var BookingService[]
     */
    protected $services = array();

    /**
     * Set daily fixed limits which cover selected interval.
     *
     * @param BookingDate $from
     * @param BookingDate $to
     * @param TableSubject $subject
     */
    public function setDailyFixedLimits($from, $to, $subject)
    {
	    $fix2num = array('mon' => '1', 'tue' => '2', 'wed' => '3', 'thu' => '4', 'fri' => '5', 'sat' => '6', 'sun' => '7');
	    $this->limits = array();
        if ($this->type == RESERVATION_TYPE_DAILY && $this->fix > 1) {
            $this->realFix = $this->fix;
            if ($subject->night_booking) {
                $this->realFix++;
            }
            $ttz = new DateTimeZone(JFactory::getUser()->getParam('timezone', JFactory::getConfig()->get('offset')));
            $end = JFactory::getDate($to->dts, $ttz);
            $day = JFactory::getDate($from->dts, $ttz);
            if (AFactory::getConfig()->hideNotCorrespondingDays) {
                if ($day->format('d') > 1) {
                    $day->modify('first day of next month');
                }
                if ($end->format('d') < $end->format('t')) {
                    $end->modify('last day of last month');
                }
                if ($subject->night_booking) {
                    $end->modify('+ 1 day');
                }
            }
            $fix_from_num = array();
            for($i=0;$i< sizeof($this->fix_from);$i++){
	            if($fix2num[$this->fix_from[$i]]){
					$fix_from_num[] = $fix2num[$this->fix_from[$i]];
	            }
            }
            while ($day->toUnix() < $end->toUnix()) {
                if (empty($this->fix_from) || in_array($day->format('N', true), $fix_from_num) && $day->diff($end)->days >= $this->realFix - 1) {
                    $this->limits[] = JModelLegacy::getInstance('DailyFixedLimit', 'BookingModel', array($day, $this));
                }
                $day->modify('+ 1 day');
            }
        }
    }

    /**
     * Add service of this type.
     *
     * @param BookingService $service
     */
    public function addService($service)
    {
        foreach ($this->limits as $limit) {
            $limit->addService($service);
        }
        if ($service->rtypeId == $this->id) {
            $this->services[] = $service;
        }
    }

    /**
     * Check if all the fixed limits are bookable.
     */
    public function checkFixedLimits()
    {
        if ($this->type == RESERVATION_TYPE_DAILY && $this->fix > 1) {
            foreach ($this->limits as $limit) {
                $limit->check();
            }
            foreach ($this->services as $service) {
                if (!$service->isFixed) {
                    $service->canReserve = false;
                }
            }
        }
    }
}
