<?php
/**
 * @package        ARTIO Booking
 * @subpackage        views
 * @copyright        Copyright (C) 2014 ARTIO s.r.o.. All rights reserved.
 * @author            ARTIO s.r.o., http://www.artio.net
 * @license        GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link            http://www.artio.net Official website
 */
defined('_JEXEC') or die;

$config = AFactory::getConfig();
$user = JFactory::getUser();

/* @var $this BookingViewOverview */

echo $this->loadTemplate('js');
?>
<div class="<?php echo $this->css; ?>" id="bookingOverview">
    <?php if ($this->h1) { ?>
        <h1><?php echo $this->h1; ?></h1>
    <?php } ?>
    <div class="header">
        <ul class="views">
            <li>
                <a href="<?php echo $this->dayRoute; ?>">
                    <?php echo JText::_('DAY_VIEW'); ?>
                </a>
            </li>
            <li>
                <a href="<?php echo $this->weekRoute; ?>" class="switchView">
                    <?php echo JText::_('WEEK_VIEW'); ?>
                </a>
            </li>
            <li>
                <a href="<?php echo $this->currentRoute; ?>">
                    <?php echo JText::_('CURRENT_WEEK'); ?>
                </a>
            </li>
        </ul>
        <h2><?php echo $this->current->title; ?></h2>
        <div class="navigator">
            <span class="prevMonth" id="prevMonth">&lt;&lt;</span>
            <strong class="currentDay">
                <?php echo $this->navigator->currentMonth; ?>
            </strong>
            <span class="nextMonth" id="nextMonth">&gt;&gt;</span>
        </div>
        <ul class="parents">
            <?php foreach ($this->hourlyParents as $parent) { ?>
                <li id="parent<?php echo $parent->id; ?>" class="parent">
                    <?php echo $parent->title; ?>
                </li>
            <?php } ?>
        </ul>
        <div class="clr"></div>
    </div>
    <table class="items">
        <thead>
        <tr>
            <th><?php echo JText::_('BOOKABLE_ITEMS'); ?></th>
            <?php foreach ($this->dailySchedule as $day) { ?>
                <th><?php echo $day->format('d'); ?></th>
            <?php } ?>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($this->children as $children) { ?>
            <tr class="schedule">
                <td class="title">
                    <?php if ($this->params->get('refer_item_detail')) { ?>
                        <a href="<?php echo JRoute::_(ARoute::view(VIEW_SUBJECT, $children->id, $children->alias)) ?>">
                            <?php echo $children->title; ?>
                        </a>
                        <?php
                    } else {
                        echo $children->title;
                    }
                    ?>
                </td>
                <?php foreach ($this->dailySchedule as $i => $day) { ?>
                    <td class="hour">
                        <?php if (!$i && !empty($this->dailyReservations[$children->id])) { ?>
                            <div class="reservations" date="<?php echo $day; ?>">
                                <?php foreach ($this->dailyReservations[$children->id] as $reservation) { ?>
                                    <?php if ($user->authorise('booking.reservations.manage', 'com_booking.subject.' . $reservation->subject)) { ?>
                                        <a class="reservation hasTooltip" up="<?php echo $reservation->up; ?>"
                                           down="<?php echo $reservation->down; ?>"
                                           title="<?php echo JHtml::tooltipText(BookingHelper::formatName($reservation), ($config->showNoteInCalendar ? JString::trim($reservation->message . ' ' . $reservation->note) : '')); ?>"
                                           href="<?php echo JRoute::_(ARoute::view(VIEW_RESERVATION, null, null, array('cid[]' => $reservation->rid))); ?>">
                                            <?php //echo BookingHelper::formatName($reservation); ?>
                                        </a>
                                    <?php } else { ?>
                                        <span class="reservation hasTooltip"
                                              up="<?php echo $reservation->up; ?>"
                                              down="<?php echo $reservation->down; ?>"
                                              title="<?php echo JHtml::tooltipText(BookingHelper::formatName($reservation), ($config->showNoteInCalendar ? JString::trim($reservation->message . ' ' . $reservation->note) : '')); ?>">
                                                        <?php //echo BookingHelper::formatName($reservation); ?>
                                                    </span>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </td>
                <?php } ?>
            </tr>
        <?php } ?>
        </tr>
        </tbody>
    </table>
</div>