<?php
/**
 * Accept a terms of something.
 * 
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */
defined('_JEXEC') or die('Restricted access');

$config = AFactory::getConfig();
$term = $config->{$this->term};

if (ISJ3) {
    JHtml::_('bootstrap.framework');
    ?>
    <label>
        <input type="checkbox" name="accept_<?php echo $this->term ?>" id="accept_<?php echo $this->term ?>" value="1">
        <?php echo JText::_('I_ACCEPT') ?> 
        <a data-toggle="modal" data-target="#<?php echo $this->term ?>" href="#<?php echo $this->term ?>"><?php echo $term->title; ?></a>
    </label>    
    <?php
    echo JHtml::_('bootstrap.renderModal', $this->term, array('title' => $term->title, 'footer' => '<button type="button" class="btn btn-default" data-dismiss="modal">' . JText::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>'), $term->text);
} else {
    ?>
    <label>
        <input type="checkbox" name="accept_<?php echo $this->term ?>" id="accept_<?php echo $this->term ?>" value="1">
        <?php echo JText::_('I_ACCEPT') ?> 
        <a class="modal" href="#<?php echo $this->term ?>"><?php echo $term->title; ?></a>
    </label>
    <div style="display: none">
        <div id="<?php echo $this->term ?>">
            <h2><?php echo $term->title; ?></h2>
            <?php echo $term->text; ?>
        </div>
    </div>
    <?php
}