<?php

/**
 * DOCman 1.4.x - Joomla! Document Manager
 * @version $Id: install.docman.helper.php 651 2008-03-20 20:33:15Z mjaz $
 * @package DOCman_1.4
 * @copyright (C) 2003-2008 The DOCman Development Team
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.joomlatools.org/ Official website
 **/

defined ( '_JEXEC' ) or die ( 'Restricted access' );

if( !defined('DS') ) define('DS', DIRECTORY_SEPARATOR);

require_once( dirname(__FILE__).DS.'docman.class.php');

$_DOCMAN = new dmMainFrame();
$_DMUSER = $_DOCMAN->getUser();

require_once($_DOCMAN->getPath('classes', 'compat'));

define( '_DM_INSTALLER_ICONPATH', JURI::root().'administrator/components/com_joomdoc/images/');

/**
 * Helper functions for the installer
 * @static
 */
class DMInstallHelper {
    function checkWritable()
    {
        $absolute_path = JPATH_ROOT;

        $paths = array(
            DS,
            DS.'administrator'.DS.'modules'.DS,
            DS.'plugins'.DS
        );

        clearstatcache();
        $msgs = array();
        foreach($paths as $path)
        {
            if(!is_writable($absolute_path.$path))
            {
            	$msgs[] =  '<font color="red">Unwriteable: &lt;joomla root&gt;'.$path . '</font><br />';
            }
        }

        if(count($msgs))
        {
            echo '<br /><p style="font-size:200%">';
        	echo implode("\n", $msgs);
            echo '</p>';
            return false;
        }

        return true;
    }

    function getDefaultFiles(){
        return array( '.htaccess', 'index.html' );
    }

    function getComponentId(){
        static $id;

        if( !$id ) {
            $database = &JFactory::getDBO();
            $database->setQuery("SELECT id FROM #__components WHERE name= 'JoomDOC'");
            $id =$database->loadResult();
        }
        return $id;
    }

    function removeAdminMenuImages(){
        $database = &JFactory::getDBO();

        $id = DMInstallHelper::getComponentId();

        $database->setQuery("UPDATE #__components SET admin_menu_img = '"._DM_INSTALLER_ICONPATH."dm_spacer_16.png' WHERE parent = $id");
        $database->query();
    }
    // Modules each have their own dir in J1.5
    function moduleFilesJ15( $action = 'move' ){
        $absolute_path = JPATH_ROOT;
        $db = &JFactory::getDBO();
        jimport('joomla.filesystem.file');

        $src = $absolute_path.DS.'administrator'.DS.'components'.DS.'com_joomdoc'.DS.'modules'.DS.'admin';
        $dest = $absolute_path.DS.'administrator'.DS.'modules';

        $files = array(
                    'mod_joomdoc_approval.php'   =>'mod_joomdoc_approval.php',
                    'mod_joomdoc_approval.xml'=>'mod_joomdoc_approval.xml',
                    'mod_joomdoc_latest.php'     =>'mod_joomdoc_latest.php',
                    'mod_joomdoc_latest.xml' =>'mod_joomdoc_latest.xml',
                    'mod_joomdoc_logs.php'       =>'mod_joomdoc_logs.php',
                    'mod_joomdoc_logs.xml'   =>'mod_joomdoc_logs.xml',
                    'mod_joomdoc_top.php'        =>'mod_joomdoc_top.php',
                    'mod_joomdoc_top.xml'    =>'mod_joomdoc_top.xml' );

        switch ($action) {
            case 'delete':
                foreach( $files as $file ){
                    $moduledir = str_replace( array('.xml', '.php'), '', $file );
                    JFile::delete($dest.DS.$moduledir.DS.$file);
                }
                
				$query = "DELETE FROM `#__modules` WHERE `position` = 'joomdoc_cpanel'";
				$db->setQuery($query);
				$db->query();
                
                break;
            default:
            case 'move':
                foreach( $files as $orig=>$file ){
                    $moduledir = str_replace( array('.xml', '.php'), '', $file );
                    if( !file_exists($dest.DS.$moduledir)) {
                    	$s = @mkdir($dest.DS.$moduledir);
                    }
                    $s = @rename( $src.DS.$orig, $dest.DS.$moduledir.DS.$file );
                }
                break;
        }
    }

    function pluginFiles( $action = 'move' ){
        $mosConfig_absolute_path = JPATH_ROOT;

        if(defined('_DM_J15')) {
        	$plugins = 'plugins';
        } else {
        	$plugins = 'mambots';
        }


        $src = $mosConfig_absolute_path.DS.'administrator'.DS.'components'.DS.'com_joomdoc'.DS.'plugins';
        $dest = $mosConfig_absolute_path.DS.$plugins.DS.'joomdoc';
        @mkdir($dest, 0755);

        $files = array(
                    'standardbuttons.php' => 'standardbuttons.php',
                    'standardbuttons.xml' => 'standardbuttons.xml');

        switch ($action) {
            case 'delete':
                foreach( $files as $file ){
                    @unlink( $dest.DS.$file );
                }

                break;
            default:
            case 'move':
                foreach( $files as $orig=>$file ){
                    @rename( $src.DS.$orig, $dest.DS.$file );
                }
                break;
        }
    }


    function fileOperations(){
    	$mosConfig_absolute_path = JPATH_ROOT;
        $root   = $mosConfig_absolute_path;
        $site   = $root.DS.'components'.DS.'com_joomdoc';
        $admin  = $root.DS.'administrator'.DS.'components'.DS.'com_joomdoc';
        $dmdoc  = $root.DS.'joomdocs';

        @mkdir ($dmdoc, 0755);
        @rename($admin.DS.'htaccess.txt', $dmdoc.DS.'.htaccess' );
        @copy  ($site.DS.'index.html', $dmdoc.DS.'index.html');

        @chmod ($site, 0755);
        @chmod ($admin.DS.'classes'.DS.'DOCMAN_download.class.php', 0755);
        @chmod ($admin.DS.'classes'.DS.'DOCMAN_utils.php', 0755);

    }

    function showLogo(){
    	?>
    	<h1><a href="index2.php?option=com_joomdoc" style="margin-left: 23px;">JoomDOC</a></h1>
        <?php
    }

    function cpanel(){
        $live_site = JURI::root();

        ?>
        <p style="margin-left: 30px; width: 400px;">
        	Thank you for installing JoomDOC.  	 
        	You can migrate your data from DOCman 1.0.x installation. 
        	Migration you can start from Controll Panel after save component configuration.  
        </p>
        <div style="clear: both;">
            <div style="float: left; margin: 30px">
                <a href="index2.php?option=com_joomdoc" style="text-decoration:none;">
                    <img border="0" align="top" alt="" src="<?php echo $live_site?>/administrator/components/com_joomdoc/images/dm_cpanel_48.png"/>
                    <br />
                    <span>Controll Panel</span>
                </a>
            </div>
            <div style="float: left; margin: 30px">
                <a href="index2.php?option=com_joomdoc&amp;task=sampledata" style="text-decoration:none;">
                    <img border="0" align="top" alt="" src="<?php echo $live_site?>/administrator/components/com_joomdoc/images/dm_newdocument_48.png"/>
                    <br />
                    <span>Add Sample Data</span>
                </a>
            </div>            
        </div>
        <?php

    }

    /**
     * Count items in tables
     */
    function cntDbRecords() {
        $database = &JFactory::getDBO();
    	$cnt = array();
        $tables = DMInstallHelper::getTablesList();

        foreach( $tables as $table ){
            $database->setQuery("SELECT COUNT(*) FROM `$table`");
            $cnt[] = (int) $database->loadResult();
        }

        // count categories
        $database->setQuery("SELECT COUNT(*) FROM `#__categories` WHERE `section` = 'com_joomdoc'");
        $cnt[] = (int) $database->loadResult();

        return array_sum($cnt);
    }

    function removeTables() {
        $database = &JFactory::getDBO();
        $tables = DMInstallHelper::getTablesList();

    	foreach( $tables as $table ){
            $database->setQuery("DROP TABLE `$table`");
            $database->query();
        }
    }

    function getTablesList(){
    	return array( '#__joomdoc', '#__joomdoc_groups', '#__joomdoc_history', '#__joomdoc_licenses', '#__joomdoc_log');
    }

    /**
     * Count the number of files in /joomdocs
     */
    function cntFiles(){
    	global $_DOCMAN;
		if(!is_object($_DOCMAN)){
			$_DOCMAN = new dmMainFrame();
		}
		if(!is_object($_DOCMAN)){
			$_DOCMAN = new dmMainFrame();
		}
        $files = DMInstallHelper::getDefaultFiles();
        $dir = DOCMAN_Compat::mosReadDirectory( $_DOCMAN->getCfg( 'dmpath' ) );
        return count( array_diff( $dir, $files ));
    }

    function removeDmdocuments(){
        global $_DOCMAN;
		if(!is_object($_DOCMAN)){
			$_DOCMAN = new dmMainFrame();
		}

        $dmpath = $_DOCMAN->getCfg( 'dmpath' );

        $files = DMInstallHelper::getDefaultFiles();

    	foreach( $files as $file ) {
            @unlink ( $dmpath.DS.$file );
        }
        @rmdir( $dmpath );
    }

    /**
     * Create index.html files
     */
    function createIndex( $path ){
        // create index.html in the path
        DMInstallHelper::_createIndexFile( $path );

        if( ! file_exists($path)) {
        	return false;
        }
        // create index.html in subdirs
        $handle = opendir( $path );
        while ($file = readdir($handle)) {
            if ($file!='.' AND $file!='..') {
                $dir = $path.DS.$file;
                if( is_dir( $dir ) ) {
                    DMInstallHelper::createIndex( $dir );
                }
            }
        }
    }

    function _createIndexFile( $dir ) {
        @$handle = fopen($dir.DS.'index.html', 'w');
        @fwrite($handle, 'Restricted access');
    }

    function moduleDB(){
    	$database = &JFactory::getDBO();

        // #__template_positions is removed in j15
        if(defined('_DM_J15')) {
        	return;
        }

        // add joomdoc_cpanel to the template positions
        $query = "SELECT COUNT(*) FROM #__template_positions WHERE position = 'joomdoc_cpanel'";
        $database->setQuery($query);
        if(!$database->loadResult()) {
        	$query = "INSERT INTO #__template_positions SET position = 'joomdoc_cpanel', description='JoomDOC'";
            $database->setQuery($query);
            $database->query();
        }

    }

     function pluginDB($action = 'insert'){
        $database = &JFactory::getDBO();

        switch($action) {
            case 'insert':
                $query = "INSERT INTO `#__plugins` (`name`, `element`, `folder`, `access`, `ordering`, `published`, `iscore`, `client_id`, `checked_out`, `checked_out_time`, `params`)"
                    ."\n VALUES ('JoomDOC Standard Buttons', 'standardbuttons', 'joomdoc', '0', '1', '1', '1', '0', '0', '0000-00-00 00:00:00', "
                    ." 'download=1\nview=1\ndetails=1\nedit=1\nmove=1\ndelete=1\nupdate=1\nreset=1\ncheckout=1\napprove=1\npublish=1')";
                break;
            case 'delete':
                $query = "DELETE FROM `#__plugins` WHERE `element`='standardbuttons' AND `folder`='joomdoc'";
                break;
        }

        $database->setQuery($query);
        $database->query();
    }

    /**
     * Upgrade tables from 1.3rc2/1.4beta2 style to 1.4rc1 style
     */
    function upgradeTables() {
    	$database = &JFactory::getDBO();
        $queries = array();

        $database->setQuery("SHOW INDEX FROM #__joomdoc");
        $database->query();
        $num_keys = $database->getNumRows();
        switch($num_keys){
            case 1: // there's only a primary index, add some more
                $queries[] = "ALTER TABLE `#__joomdoc` ADD INDEX `pub_appr_own_cat_name`  (`published`, `approved`, `dmowner`, `catid`, `dmname`(64))";
                $queries[] = "ALTER TABLE `#__joomdoc` ADD INDEX `appr_pub_own_cat_date`  (`approved`, `published`, `dmowner`, `catid`, `dmdate_published`)";
                $queries[] = "ALTER TABLE `#__joomdoc` ADD INDEX `own_pub_appr_cat_count` (`dmowner`, `published`, `approved`, `catid`, `dmcounter`)";
                // pass through (more can be added later on)
            default:
                break;
        }

        foreach($queries as $query) {
            $database->setQuery($query);
            if(! $database->query()) {
            	echo 'Error upgrading tables';
            }
        }
    }
}
