<?php
/**
 * Artio DOCman2 2.0.0 - Joomla! Document Manager
 * @version     $Id: categories.php $
 * @package     DOCman2
 * @subpackage  helpers
 * @copyright	Copyright (C) 2009 ARTIO s.r.o.. All rights reserved. 
 * @author 		ARTIO s.r.o., http://www.artio.net
 **/
defined ( '_JEXEC' ) or die ( 'Restricted access' );

define ( 'DTMP_CATEGORY_DEFAULT', 'categories/category.tpl.php' );
define ( 'DTMP_CATEGORY_LIST', 'categories/list.tpl.php' );

class CategoriesHelper {
	
	function fetchCategory($id, $vtpl) {
		$dmuser = DocmanFactory::getDmuser ();
		
		$cat = new DOCMAN_Category ( $id );
		
		// if the user is not authorized to access this category, redirect
		if (! $dmuser->canAccessCategory ( $cat->getDBObject () )) {
			DocmanHelper::_returnTo ( '', _DML_NOT_AUTHORIZED );
		}
		
		DOCMAN_Utils::processContentBots ( $cat, 'description' );
		
		$tpl = &new DOCMAN_Theme ( );
		
		$tpl->path = DocmanHelper::getPath ( DTMP_CATEGORY_DEFAULT, $vtpl,true );
		
		$tpl->assignRef ( 'links', $cat->getLinkObject () );
		$tpl->assignRef ( 'paths', $cat->getPathObject () );
		$tpl->assignRef ( 'data', $cat->getDataObject () );
		
		return $tpl->fetch ( DTMP_CATEGORY_DEFAULT );
	}
	
	function fetchCategoryList($id,$vtpl) {
		$theme = DocmanHelper::getPath ( DTMP_CATEGORY_LIST, $vtpl,true );
		$docman = &DocmanFactory::getDocman();
		DocmanFactory::setTheme($docman,$theme);
		
		$children = DOCMAN_Cats::getChildsByUserAccess ( $id );
		$items = array ();
		foreach ( $children as $child ) {
			$cat = new DOCMAN_Category ( $child->id );
			
			// process content mambots
			DOCMAN_Utils::processContentBots ( $cat, 'description' );
			
			$item = new StdClass ( );
			$item->links = &$cat->getLinkObject ();
			$item->paths = &$cat->getPathObject ();
			$item->data = &$cat->getDataObject ();
			$items [] = $item;
		}
		$tpl = &new DOCMAN_Theme ( );
		$tpl->path = $theme;
		$tpl->assignRef ( 'items', $items );
		return $tpl->fetch ( DTMP_CATEGORY_LIST );
	}
}
?>