<?php
/**
 * SEF module for Joomla!
 *
 * @author      $Author: michal $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     $Name$, ($Revision: 4994 $, $Date: 2005-11-03 20:50:05 +0100 (??t, 03 XI 2005) $)
 */

// Security check to ensure this file is being included by a parent file.
if (!defined('_VALID_MOS') && !defined('JPATH_BASE')) die('Direct Access to this location is not allowed.');

function com_install()
{
    // Enable the legacy plugin if needed
    $enabled = JPluginHelper::isEnabled('system', 'legacy');
    if( !$enabled ) {
        // Enable plugin
        $db = & JFactory::getDBO();
        $query = "UPDATE `#__plugins` SET `published` = '1' WHERE (`folder` = 'system') AND (`element` = 'legacy') LIMIT 1";
        $db->setQuery($query);
        $db->query();
        
        // Load plugin from database
        $query = "SELECT `folder` AS `type`, `element` AS `name`, `params` FROM `#__plugins` WHERE (`folder` = 'system') AND (`element` = 'legacy')";
        $db->setQuery($query);
        $plugin = $db->loadObject();
        
        // Import plugin
        JPluginHelper::_import($plugin);
    }
    
    global $database, $mosConfig_absolute_path, $mosConfig_live_site;
    
    // Change SB menu icon.
    $database->setQuery("SELECT id FROM #__components WHERE admin_menu_link = 'option=com_sef'");
    $id = $database->loadResult();

    // Set new admin menu image.
    $database->setQuery("UPDATE #__components " .
    "SET admin_menu_img  = '../administrator/components/com_sef/images/icon.png'" .
    "WHERE id='$id'");
    $database->query();

    // Install JoomSEF MetaBot.
    if (!is_dir($mosConfig_absolute_path.'/plugins/system')) {
        mosMakePath($mosConfig_absolute_path.'/plugins/', 'system');
    }
    rename($mosConfig_absolute_path.'/administrator/components/com_sef/bots/joomsef_metabot.php', $mosConfig_absolute_path.'/plugins/system/joomsef_metabot.php');
    rename($mosConfig_absolute_path.'/administrator/components/com_sef/bots/joomsef_metabot.xml.tmp', $mosConfig_absolute_path.'/plugins/system/joomsef_metabot.xml');
    @rmdir($mosConfig_absolute_path.'/administrator/components/com_sef/bots');
    $database->setQuery("INSERT INTO #__plugins
	                    (id, name, element, folder, access, ordering, published, iscore, client_id, checked_out, checked_out_time, params)
	                    VALUES ('', 'System - ARTIO JoomSEF MetaBot', 'joomsef_metabot', 'system', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', 'rewrite_keywords=1\nrewrite_description=1\nprefer_joomsef_title=1\nuse_sitename=2\nsitename_sep=-')");
    $database->query();

    // Patch the router.php file
    $path = JPATH_LIBRARIES.DS.'joomla'.DS.'application'.DS.'router.php';
    if( is_writeable($path) ) {
        $f = file_get_contents($path);

        $replace = '// ARTIO SEF PATCH START
            if( $client == \'site\' ) {
                global $sef_config_file;
                
                $path = JPATH_ROOT.DS.\'components\'.DS.\'com_sef\'.DS.\'sef.router.php\';
                $sef_config_class = JPATH_ADMINISTRATOR.DS.\'components\'.DS.\'com_sef\'.DS.\'sef.class.php\';
                $sef_config_file  = JPATH_ADMINISTRATOR.DS.\'components\'.DS.\'com_sef\'.DS.\'config.sef.php\';

                if(file_exists($path)) {
                    require_once($path);
                } else {
                    $error = JError::raiseError( 500, \'Unable to load router: \'.$client);
                    return $error;
                }

                $noRead = JText::_(\'FATAL ERROR: Unable to read file \');
                $chkPerms = JText::_(\'Please check your file permissions and ensure that that this file can be read.\');
                if (!is_readable($sef_config_file)) die($noRead."($sef_config_file)<br />".$chkPerms);
                if (is_readable($sef_config_class)) require_once($sef_config_class);
                else die($noRead."( $sef_config_class )<br />".$chkPerms);

                global $sefConfig;
                $sefConfig = new SEFConfig();
                
                if( $sefConfig->enabled ) {
                    $instance = new JRouterArtio($options);
                }
            }
            // ARTIO SEF PATCH END
			
			$0';

        $f = preg_replace('/\$instances\[\$client\]\s*=\s*&\s*\$instance;/', $replace, $f, 1);
        file_put_contents($path, $f);
        $patch = 'router.php successfully patched.';
    } else {
        $patch = 'router.php could not be patched. Please, add the following code just before the \'$instances[$client] = & $instance;\' line of JRouter::getInstance() function.'.
        '<br /><br />'.
        '// ARTIO SEF PATCH START<br />'.
        'if( $client == \'site\' ) {<br />'.
        '    global $sef_config_file;<br />'.
        '<br />'.
        '    $path = JPATH_ROOT.DS.\'components\'.DS.\'com_sef\'.DS.\'sef.router.php\';<br />'.
        '    $sef_config_class = JPATH_ADMINISTRATOR.DS.\'components\'.DS.\'com_sef\'.DS.\'sef.class.php\';<br />'.
        '    $sef_config_file  = JPATH_ADMINISTRATOR.DS.\'components\'.DS.\'com_sef\'.DS.\'config.sef.php\';<br />'.
        '<br />'.
        '    if(file_exists($path)) {<br />'.
        '        require_once($path);<br />'.
        '    } else {<br />'.
        '        $error = JError::raiseError( 500, \'Unable to load router: \'.$client);<br />'.
        '        return $error;<br />'.
        '    }<br />'.
        '<br />'.
        '    $noRead = JText::_(\'FATAL ERROR: Unable to read file \');<br />'.
        '    $chkPerms = JText::_(\'Please check your file permissions and ensure that that this file can be read.\');<br />'.
        '    if (!is_readable($sef_config_file)) die($noRead."($sef_config_file)<br />".$chkPerms);<br />'.
        '    if (is_readable($sef_config_class)) require_once($sef_config_class);<br />'.
        '    else die($noRead."( $sef_config_class )<br />".$chkPerms);<br />'.
        '<br />'.
        '    global $sefConfig;<br />'.
        '    $sefConfig = new SEFConfig();<br />'.
        '<br />'.
        '    if( $sefConfig->enabled ) {<br />'.
        '        $instance = new JRouterArtio($options);<br />'.
        '    }<br />'.
        '}<br />'.
        '// ARTIO SEF PATCH END';
    }

    // Install content elements if JoomFish is present
    if (file_exists($mosConfig_absolute_path . '/administrator/components/com_joomfish/config.joomfish.php')) {
        @rename( "$mosConfig_absolute_path/administrator/components/com_sef/contentelements/sefext.titles.xml", "$mosConfig_absolute_path/administrator/components/com_joomfish/contentelements/sefext.titles.xml");
        @rename( "$mosConfig_absolute_path/administrator/components/com_sef/contentelements/sefext.texts.xml", "$mosConfig_absolute_path/administrator/components/com_joomfish/contentelements/sefext.texts.xml");
        @rename( "$mosConfig_absolute_path/administrator/components/com_sef/contentelements/translationJSextensionFilter.php", "$mosConfig_absolute_path/administrator/components/com_joomfish/contentelements/translationJSextensionFilter.php");
    }
    else {
        @unlink( "$mosConfig_absolute_path/administrator/components/com_sef/contentelements/sefext.titles.xml" );
        @unlink( "$mosConfig_absolute_path/administrator/components/com_sef/contentelements/sefext.texts.xml" );
        @unlink( "$mosConfig_absolute_path/administrator/components/com_sef/contentelements/translationJSextensionFilter.php" );
    }

    ob_start();

    echo '<div class="quote" style="text-align: center;">';
    echo '<h1>ARTIO JoomSEF installed succesfully!</h1>';
    echo '<h3>You must first edit the configuration, enable it and save before it will become active.</h3>';
    $readdocs = '<p class="message">Please scroll down and read the documentation.<br/>There is still extra configuration that you need to complete for ';
    if (!(strpos($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS') === false)) {
        echo $readdocs.'IIS.</p>';
    }
    else {
        // Get the correct rewrite base
        $url = parse_url($mosConfig_live_site);

        if( empty($url['path']) ) {
            $base = '/';
        } else {
            $base = $url['path'];
        }

        if( substr($base, -1) != '/' ) {
            $base .= '/';
        }
        
        if( substr($base, 0, 1) != '/' ) {
            $base = '/' . $base;
        }

        // Create htaccess content
        $htaccess = "
##
# @package ARTIO JoomSEF
# @copyright Copyright (C) ARTIO s.r.o. All rights reserved.
# @license http://www.artio.net/en/joomsef/artio-joomsef-license-and-pricing
##

#####################################################
#  READ THIS COMPLETELY IF YOU CHOOSE TO USE THIS FILE
#
# The line just below this section: 'Options +FollowSymLinks' may cause problems
# with some server configurations.  It is required for use of mod_rewrite, but may already
# be set by your server administrator in a way that dissallows changing it in
# your .htaccess file.  If using it causes your server to error out, comment it out (add # to
# beginning of line), reload your site in your browser and test your sef url's.  If they work,
# it has been set by your server administrator and you do not need it set here.
#
#####################################################

##  Can be commented out if causes errors, see notes above.
Options +FollowSymLinks
        
DirectoryIndex index.php

RewriteEngine On
RewriteBase {$base}

RewriteCond %{REQUEST_URI} ^(/component/option,com) [NC,OR]
RewriteCond %{REQUEST_URI} (/|\.htm|\.php|\.html|/[^.]*)$  [NC]
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule (.*) index.php

########## Begin - Rewrite rules to block out some common exploits
## If you experience problems on your site block out the operations listed below
## This attempts to block the most common type of exploit `attempts` to Joomla! 
#                              
# Block out any script trying to set a mosConfig value through the URL
RewriteCond %{QUERY_STRING} mosConfig_[a-zA-Z_]{1,21}(=|\%3D) [OR]
# Block out any script trying to base64_encode crap to send via URL
RewriteCond %{QUERY_STRING} base64_encode.*\(.*\) [OR]
# Block out any script that includes a <script> tag in URL
RewriteCond %{QUERY_STRING} (\<|%3C).*script.*(\>|%3E) [NC,OR]
# Block out any script trying to set a PHP GLOBALS variable via URL
RewriteCond %{QUERY_STRING} GLOBALS(=|\[|\%[0-9A-Z]{0,2}) [OR]
# Block out any script trying to modify a _REQUEST variable via URL
RewriteCond %{QUERY_STRING} _REQUEST(=|\[|\%[0-9A-Z]{0,2})
# Send all blocked request to homepage with 403 Forbidden error!
RewriteRule ^(.*)$ index.php [F,L]
# 
########## End - Rewrite rules to block out some common exploits
	";

        //if (substr(PHP_OS, 0, 3) == 'WIN') {
        //	echo '<p class="error">Found apache on windows, .htaccess is an illegal filename for this system.<br/>You must complete the rest of the configuration manually.</p>';
        //	echo $readdocs."the apache .htaccess file.</p>";
        //}
        //else{
        echo '<p style="text-align: center;">Checking for .htaccess in Joomla! root...<br />';
        if(!file_exists($GLOBALS['mosConfig_absolute_path'].DIRECTORY_SEPARATOR.'.htaccess')){
            echo 'not found.</p>';
            $file = fopen($GLOBALS['mosConfig_absolute_path'].DIRECTORY_SEPARATOR.'.htaccess', 'w+');
            if(!$file){
                echo '<p style="text-align: center;" class="error">Unable to create .htaccess file in your Joomla! root. Please create this file yourself and add the following lines:<br/><pre>'.htmlspecialchars($htaccess).'</pre>';
            }
            else{
                fwrite($file, $htaccess);
                fclose($file);
                echo "Successfully created .htaccess file in your Joomla! root with the following content:<br/><pre>".htmlspecialchars($htaccess)."</pre>";
            }
            echo "Please check that the RewriteBase directive path is set correctly and matches your configuration.";
        }
        else {
            echo '<span class="error">Found existing .htaccess in Joomla! root.</span></p>';
            echo $readdocs.'the apache .htaccess file</p>';
        }
        echo '</div>';
    }

    echo '<div style="text-align: left">';
    echo '<h3>Patching /libraries/joomla/application/router.php</h2>';
    echo $patch;
    echo '</div><br /><br />';

    include($GLOBALS['mosConfig_absolute_path'].'/administrator/components/com_sef/readme.inc.html');

    $output = ob_get_contents();
    ob_end_clean();

    echo $output;
}
?>
